# coding: utf-8
from sandbox import sdk2

GOODS_RUNTIME_RELEASERS = [
    "yurikiselev",
    "starcev",
    "robot-goods",
    "web-chib",
    "my34",
    "gilazhev",
    "aleksko"
    "flyrise",
    "GOODS-RUNTIME"
]


class GoodsApphostBackendsPkg(sdk2.Resource):
    """Common package for deploying goods backends at apphost"""
    ttl = 'inf'
    releasable = True
    auto_backup = True
    releasers = GOODS_RUNTIME_RELEASERS


class GoodsReportModelsArchive(sdk2.Resource):
    """Resource with models for goods report"""
    releasable = True
    releasers = GOODS_RUNTIME_RELEASERS
    executable = False
    ttl = 30


class GoodsBasesearchShard(sdk2.Resource):
    """Resource with goods basesearch shard"""
    releasable = True
    releasers = GOODS_RUNTIME_RELEASERS
    executable = False
    auto_backup = True
    ttl = 30


class GoodsBasesearchShardmap(sdk2.Resource):
    """Resource with shardmap for goods basesearch"""
    releasable = True
    releasers = GOODS_RUNTIME_RELEASERS
    executable = False
    auto_backup = True
    ttl = 30


class GoodsBasesearchBetaShardmap(sdk2.Resource):
    """Resource with shardmap for goods basesearch"""
    releasable = True
    releasers = GOODS_RUNTIME_RELEASERS
    executable = False
    auto_backup = True
    ttl = 30


class GoodsBasesearchExpShardmap(sdk2.Resource):
    """Resource with shardmap for goods basesearch"""
    releasable = True
    releasers = GOODS_RUNTIME_RELEASERS
    executable = False
    auto_backup = True
    ttl = 30


class GoodsReportData(sdk2.Resource):
    """Resource with data for goods report"""
    releasable = True
    releasers = GOODS_RUNTIME_RELEASERS
    executable = False
    auto_backup = True
    ttl = 30


class GoodsReportBinary(sdk2.Resource):
    """Resource with report binary"""
    releasable = True
    releasers = GOODS_RUNTIME_RELEASERS
    ttl = 100


class GoodsReportCtlBinary(sdk2.Resource):
    """Resource with report_ctl binary"""
    releasable = True
    releasers = GOODS_RUNTIME_RELEASERS
    ttl = 100


class GoodsReportFlags(sdk2.Resource):
    """Resource with experiment and emergency flags"""
    releasable = True
    releasers = GOODS_RUNTIME_RELEASERS
    ttl = 'inf'


class GoodsReportMetaFlags(sdk2.Resource):
    """Resource with experiment and emergency flags"""
    releasable = True
    releasers = GOODS_RUNTIME_RELEASERS
    ttl = 'inf'


class GoodsIndexerBinaries(sdk2.Resource):
    """Resource with goods indexer binaries bundle"""
    releasable = True
    releasers = GOODS_RUNTIME_RELEASERS
    ttl = 30


class GoodsIndexerConfigs(sdk2.Resource):
    """Resource with goods indexer configs bundle"""
    releasable = True
    releasers = GOODS_RUNTIME_RELEASERS
    ttl = 30


class GoodsIndexerInputData(sdk2.Resource):
    """Resource with goods indexer input data"""
    releasable = True
    releasers = GOODS_RUNTIME_RELEASERS
    ttl = 30


class GoodsIndexerInputMboData(sdk2.Resource):
    """Resource with goods indexer input mbo_stuff data (with models data)"""
    releasable = True
    releasers = GOODS_RUNTIME_RELEASERS
    ttl = 30


class GoodsIndexerSvnData(sdk2.Resource):
    """Resource with goods indexer svn data"""
    releasable = True
    releasers = GOODS_RUNTIME_RELEASERS
    ttl = 30


class GoodsIndexerBidsData(sdk2.Resource):
    """Resource with goods indexer bids data"""
    releasable = True
    releasers = GOODS_RUNTIME_RELEASERS
    ttl = 30


class GoodsMetaConfigBundle(sdk2.Resource):
    """Resource with goods configs for meta services"""
    releasable = True
    releasers = GOODS_RUNTIME_RELEASERS
    ttl = 30


class GoodsBaseConfigBundle(sdk2.Resource):
    """Resource with goods configs for base services"""
    releasable = True
    releasers = GOODS_RUNTIME_RELEASERS
    ttl = 30


class GoodsConfigBundle(sdk2.Resource):
    """Resource with goods configs for all report services"""
    releasable = True
    releasers = GOODS_RUNTIME_RELEASERS
    ttl = 30


class GoodsReportMetaAmmo(sdk2.Resource):
    """Resource with ammo for goods meta services"""
    releasable = True
    releasers = GOODS_RUNTIME_RELEASERS
    ttl = 30


class GoodsReportDynamicModelsArchive(sdk2.Resource):
    """Resource with models for goods report"""
    releasable = True
    releasers = GOODS_RUNTIME_RELEASERS
    executable = False
    ttl = 30
