import logging
import requests

from sandbox import sdk2

logger = logging.getLogger('hitman')


class GtaHitmanProcessLaunchTask(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        process_id = sdk2.parameters.String('process id', required=True)
        hitman_api_url = sdk2.parameters.String('hitman api url', required=True,
                                                default='https://hitman.qloud.yandex-team.ru')

    @property
    def hitman_token(self):
        return sdk2.Vault.data("GTA", "ltv_hitman_token")

    @property
    def headers(self):
        return {
            'Content-Type': 'application/json',
            'Authorization': 'OAuth {}'.format(self.hitman_token),
        }

    @property
    def start_proc_url(self):
        return '/'.join([self.Parameters.hitman_api_url, 'api/v1/execution/start', self.Parameters.process_id])

    @property
    def request_data(self):
        data = dict()
        data['requester'] = 'robot-ltv'
        return data

    def on_execute(self):
        resp = requests.post(self.start_proc_url, headers=self.headers, json=self.request_data)
        logger.info('Hitman response: ', resp.content)
