import sandbox.projects.common.constants as consts
import sandbox.projects.common.build.parameters as build_parameters

from sandbox import sdk2
from sandbox.common.types.client import Tag
from sandbox.projects.common.nanny.nanny import ReleaseToNannyTask2
from sandbox.projects.common.build.YaMake2 import YaMake2
from sandbox.projects.hatter import resources


class BuildHatter(ReleaseToNannyTask2, YaMake2):
    class Requirements(sdk2.Requirements):
        client_tags = Tag.Group.LINUX

    class Parameters(sdk2.Task.Parameters):
        build_output_html_ttl = 7
        build_output_ttl = 7

        checkout_arcadia_from_url = sdk2.parameters.ArcadiaUrl(
            'Vcs url for arcadia',
            required=True
        )

        with sdk2.parameters.CheckGroup("Resources to build") as build_targets:
            for r in sorted(resources.HATTER_TARGETS):
                build_targets.values[r] = r

        with sdk2.parameters.RadioGroup('Build type') as build_type:
            build_type.values.release = build_type.Value('release', default=True)
            build_type.values.debug = 'debug'
            build_type.values.profile = 'profile'

        arcadia_patch = sdk2.parameters.String(
            'Apply patch (diff file rbtorrent, paste.y-t.ru link or plain text). Doc: https://nda.ya.ru/3QTTV4',
            default='', multiline=True
        )

        with sdk2.parameters.RadioGroup("Sanitize") as sanitize_group:
            sanitize_group.values.none = sanitize_group.Value(default=True)
            sanitize_group.values.address = None
            sanitize_group.values.leak = None
            sanitize_group.values.memory = None
            sanitize_group.values.thread = None
            sanitize_group.values.undefined = None

        definition_flags = build_parameters.DefinitionFlags()
        yt_store_parameters = build_parameters.YtStoreParameters()

        coverage_prefix_filter = None
        coverage_exclude_regexp = ''
        coverage_unified_agent = False
        coverage_unified_agent_sid = ''
        coverage_unified_agent_strict = False
        distbuild_pool = None
        test_size_filter = None
        java_coverage = False
        javac_options = None
        jvm_args = None
        musl = False
        lto = False
        thinlto = False
        pgo_add = False
        pgo_use = None
        pgo_merge_timeout = 600
        vault_owner = None
        vault_key_name = None
        test_params = {}
        clear_build = False
        keep_on = False
        tests_requested = False
        allure_report = False
        allure_report_ttl = 4
        test_type_filter = None
        junit_report = False
        use_system_python = False
        make_context_on_distbuild = False
        check_dependencies = False
        use_dev_version = False
        create_html_results_resource = True
        ram_drive_size = None
        check_return_code = True
        strip_binaries = sdk2.parameters.Bool('Strip result binaries', default=True)
        use_aapi_fuse = True
        use_arc_instead_of_aapi = False
        aapi_fallback = True
        build_system = consts.SEMI_DISTBUILD_BUILD_SYSTEM
        binary_executor_release_type = "none"
        env_vars = None
        target_platform = None
        ya_add_result = []
        test_filters = None
        report_tests_only = False
        test_log_level = 'debug'
        test_tag = None
        disable_test_timeout = False
        force_build_depends = False
        force_vcs_info_update = False
        ignore_recurses = False
        test_threads = 0
        cache_test_results = False
        tests_retries = 1
        target_platform_flags = None
        host_platform_flags = None
        checkout = False
        sonar = False
        sonar_default_project_filter = False
        sonar_options = None
        sonar_project_filter = None
        failed_tests_cause_error = True
        trace_ya_output = False
        dir_outputs = True
        use_prebuilt_tools = 'default'
        ya_make_extra_parameters = []
        run_tagged_tests_on_yt = False
        yt_store_exclusive = False
        force_sandbox_tags = False
        do_not_remove_resources = sdk2.parameters.Bool("Do not remove resources", required=True, default=False)

    def get_target_res_type(self, target):
        return resources.HATTER_TARGETS[target].res_type

    def on_execute(self):
        with self.memoize_stage.start_child_tasks_and_build:
            YaMake2.on_execute(self)

    def on_release(self, additional_parameters):
        ReleaseToNannyTask2.on_release(self, additional_parameters)
        sdk2.Task.on_release(self, additional_parameters)
