from sandbox import sdk2


hatter_releasers = [
    'gous32',
    'alex-stanovoy',
    'antervis',
    'akhovrychev',
]

hatter_subscribers = ['hatter_releasers']


class ChewerBinary(sdk2.Resource):
    name = 'CHEWER_BINARY'
    any_arch = False
    executable = True
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = hatter_releasers
    release_subscribers = hatter_subscribers
    arcadia_build_path = 'robot/hatter/chewer/bin'
    bin_name = 'chewer'
    res_type = 'build'


class PourerBinary(sdk2.Resource):
    name = 'POURER_BINARY'
    any_arch = False
    executable = True
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = hatter_releasers
    release_subscribers = hatter_subscribers
    arcadia_build_path = 'robot/hatter/pourer/bin'
    bin_name = 'pourer'
    res_type = 'build'


HATTER_TARGETS = {
    ChewerBinary.name: ChewerBinary,
    PourerBinary.name: PourerBinary,
}
