## Написание бинарных задачек для health
-----

### Вводная
- https://wiki.yandex-team.ru/sandbox/  
- https://wiki.yandex-team.ru/sandbox/tasks/  

### Обычные задачки
- https://wiki.yandex-team.ru/sandbox/quickstart/  
Заведение машинки по инструкции и отладка кода не ней.  
Сервер sandbox'a поднимается довольно долго на машинке c  
(ram-8gb, cpu-2cores). Около 10 минут. Стоит учесть это при выделении ресурсов.  
> by @denvr - сегмент для таких машин - default.  

Изменение кода таких задач приводит к перезапуске сервера  
(изменения подхватываются на лету).  

Общение с sandbox'ом происходит через скрипт  
`./arcadia/sandbox/sandbox`

Полезно:  
- `./arcadia/sandbox/sandbox info`  

### Бинарные задачки
На данный момент в проекте есть бинарная задачка  
`sandbox/projects/health/generate_yamd_database`  
 
Обычные задачки пишутся на Python'e,  
помечаются в ya.make как PY2_LIBRARY  
и исполняются Sandbox'им Python'ом.  

При этом - импортировать что - то из аркадии в них по-хорошему нельзя.  
Здесь приходят на выручку бинарные задачи.  
Они собираются с аркадийным python-ом и помечаются в ya.make как SANDBOX_TASK.  
такие задачи могут использовать PEERDIR-ы на аркадийные модули.  

Однако, в код этих задач заходит также и sandbox'ий python.  
Он смотрит описание задач и ресурсов,  
чтобы составить модель нашей задачки и дать знать о ней sandbox'у.  

В итоге, код должен успешно исполняться в 2 интерпретаторах:  
- sandbox'ом python'e (который не умеет в PEERDIR-ы)  
- акрадийном python'e  

Это требует написания гибридного кода.  
В нашем проекте мы по максимуму попытались отделить эти 2 части.  
В качестве примера смотри `sandbox/projects/health/generate_yamd_database`.  

sandbox'ий python заходит в init, смотрит определение задачи и выходит с метаданными о ней.  
акрадийный python при выполнении задачи предоставляет возможность зайти дальше - в метод execute.  

Мне удобно представлять бинарную задачку в 2 ипостасях:  
- метаданные задачи без on_execute, которые могут ссылаться на любой бинарник с кодом задачи  
- непосредственно бинарник с задачей  

### Процесс разработки бинарных задач  
- 1 - можно закоммитить описание ресурсов и задачи с пустым on_execute,  
чтобы метаданные проросли в sandbox (это включает параметры задачи, типы ресурсов и задач).  
После этого можно будет создать задачку нужного типа и увидеть в интерфейсе параметры.  
Одно но - она не отработает успешно без исполняющего кода в бинарнике.  

- 2 - воспользоваться особенностью бинарных задач и отлаживать их на production'e.  
Для этого есть опции run, upload.  
Мы можем подсунуть нашим "метаданным" любой бинарник.  

**Более корректный в ряде случаев путь**
- 0 - если у задачи сложный интерфейс и серверные методы (on_save, on_enqueue, on_create и т.д.) 
То открывать ревью на каждую правку, дожидаться ее попадания в master - некорректно.
В этом случае стоит отладить интерфейс на виртуальной машине со своим sandbox'ом.
 
У нас есть не шибко шустрая машинка с рабочим sandbox'ом
https://qyp.yandex-team.ru/vm/sas/ya-health-sandbox
Она настроена на порт
http://ya-health-sandbox.sas.yp-c.yandex.net:13337/
Только нужно добавиться в машинку как owner и подождать, пока прорастет ключ

- 1 - пишем код и собираем его в бинарник 
- 2 - заливаем на машинку код с бинарником 
scp -r task_folder_from_health username@ya-health-sandbox.sas.yp-c.yandex.net:arcadia/sandbox/projects/health/
- 3 - зайти на машинку: ssh ya-health-sandbox.sas.yp-c.yandex.net
- 4 - внутри машинки дождаться перезапуска sandbox'а (он автоматомо подхватит новый код)
- 5 - залить бинарник с аттрибутами --no-auth --skynet --url "http://ya-health-sandbox.sas.yp-c.yandex.net:13337/"
- 6 - создать в интерфейсе задачу нужного типа и выполнить ее с нужным бинарником

Подробности:  
- https://wiki.yandex-team.ru/sandbox/tasks/build/  
- https://clubs.at.yandex-team.ru/arcadia/16437  

### Q&A
- RadioGroup - работает довольно хитро (см generate_yamd_database)  
- если чистый sandbox на виртуальной машинке падает - стоит подтянуть обновления.  
скорее всего - ошибка в какой - то из задач. скорее всего - это уже починили.  
- кнопка Release в интерфейсе позволяет перевести все ресурсы задачки в нужный статус  
- если хотите, чтобы логи появлялись во вкладке Logs задачи - не стоит перенастраивать logging.  
- не стоит валидировать параметры в методе on_save. в случае стечения ряда обстоятельств, можно написать задачу, 
которую нельзя создать в интерфейсе.
- требуемые ресурсы стоит указать в параметрах, а в последствии скачать с использованием sdk2.ResourceData(resource)
