# coding: utf-8

import json

from sandbox.projects.common.build import parameters as build_parameters
from sandbox.projects.common.nanny import nanny
from sandbox.projects.common.build.KosherYaPackage import KosherYaPackage
import sandbox.projects.common.constants as consts
from sandbox.projects.common.build.ya_package_config import consts as ya_package_consts


class BuildHollywoodPackage(KosherYaPackage, nanny.ReleaseToNannyTask2):

    class Requirements(KosherYaPackage.Requirements):
        pass

    class Parameters(KosherYaPackage.Parameters):
        resource_type = build_parameters.ResourceType(default_value='HOLLYWOOD_PACKAGE')
        packages = build_parameters.Packages(default_value='alice/hollywood/shards/common/prod/hollywood_package.json')
        build_type = build_parameters.BuildType(default_value=consts.RELEASE_BUILD_TYPE)
        publish_package = build_parameters.PublishPackage(default_value=False)
        raw_package = build_parameters.RawPackage(default_value=False)
        package_type = build_parameters.PackageType(default_value=ya_package_consts.PackageType.TARBALL.value)
        do_not_remove_resources = build_parameters.DoNotRemoveResources2(default_value=False)
        compress_package_archive = build_parameters.CompressPackageArchive(default=True)

    def on_enqueue(self):
        super(BuildHollywoodPackage, self).on_enqueue()

    def on_release(self, additional_parameters):
        self.set_info("additional_parameters: {}".format(json.dumps(additional_parameters)))
        nanny.ReleaseToNannyTask2.on_release(self, additional_parameters)
        super(BuildHollywoodPackage, self).on_release(additional_parameters)
