from sandbox import sdk2

import releasers


class HollywoodPackage(sdk2.Resource):
    """
    Hollywood tarball package
    """
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = releasers.hollywood_releasers


class HollywoodGeneralConversationPackage(sdk2.Resource):
    """
    Hollywood GeneralConversation shard tarball package
    """
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = releasers.hollywood_general_conversation_releasers


class HollywoodGoodwinPackage(sdk2.Resource):
    """
    Hollywood Goodwin shard tarball package
    """
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = releasers.hollywood_goodwin_releasers


class HollywoodFastData(sdk2.Resource):
    """
    Fast Data for Hollywood Common (raw data)
    """
    releasable = True
    auto_backup = True
    releasers = releasers.hollywood_all
    revision = sdk2.Attributes.Integer('Arcadia revision', required=True)
    version = sdk2.Attributes.Integer('Version', required=True)
    shard = sdk2.Attributes.String('Shard', required=True)


class HollywoodFastDataBundle(sdk2.Resource):
    """
    Fast Data for Hollywood Common (.tar.gz)
    """
    releasable = True
    auto_backup = True
    releasers = releasers.hollywood_all
    revision = sdk2.Attributes.Integer('Arcadia revision', required=True)
    version = sdk2.Attributes.Integer('Version', required=True)
    shard = sdk2.Attributes.String('Shard', required=True)


class HollywoodFastDataDeployConfig(sdk2.Resource):
    """
    Config for Hollywood Fast Data Deployer
    """
    executable = False
    releasable = False


class HollywoodCommonFastDataDeployConfig(HollywoodFastDataDeployConfig):
    """
    Config for Hollywood Common Fast Data Deployer
    """
    executable = False
    releasable = True
    releasers = releasers.hollywood_releasers


class HollywoodGeneralConversationFastDataDeployConfig(HollywoodFastDataDeployConfig):
    """
    Config for Hollywood GeneralConversation Fast Data Deployer
    """
    executable = False
    releasable = True
    releasers = releasers.hollywood_general_conversation_releasers


class HollywoodAmmo(sdk2.Resource):
    """
    Ammo (a grpc_client_plan for apphost/tools/grpc_client).
    """
    auto_backup = True
    releasable = True
    releasers = releasers.hollywood_all


class HollywoodBassAmmo(sdk2.Resource):
    """
    Hollywood Bass Ammo
    """
    auto_backup = True
    releasable = True
    releasers = releasers.hollywood_all


class HollywoodDiff(sdk2.Resource):
    """
    Package with Hollywood responses diff
    """
    auto_backup = True


class HollywoodBassDiff(sdk2.Resource):
    """
    Package with Hollywood BASS responses diff
    """
    auto_backup = True


class MarkerTestsBinary(sdk2.Resource):
    """
    Binary for running marker tests
    """
    executable = False
    releasable = True
    releasers = releasers.hollywood_releasers


class MarkerTestsConfig(sdk2.Resource):
    """
    Config for running marker tests
    """


class MarkerTestsLogs(sdk2.Resource):
    """
    Marker tests logs
    """


class AnalyticsInfoTestsBinary(sdk2.Resource):
    """
    Binary for running AnalyticsInfo tests
    """
    executable = False
    releasable = True
    releasers = releasers.hollywood_releasers


class AnalyticsInfoTestsConfig(sdk2.Resource):
    """
    Config for running AnalyticsInfo tests
    """


class AnalyticsInfoTestsLogs(sdk2.Resource):
    """
    AnalyticsInfo tests logs
    """


class AppHostPandoraGunExecutable(sdk2.Resource):
    """
    Executable of a apphost/tools/pandora_gun/gun for Hollywood perf testing.
    """
    auto_backup = True
    releasable = True
    releasers = releasers.hollywood_releasers
