import json
import requests


class HollywoodYappyToolbox(object):
    @staticmethod
    def get_yappy_slots(yappy_name, yappy_token, logger, beta_type):
        r = requests.post(
            "https://yappy.z.yandex-team.ru/api/yappy.services.Model/retrieveBetasSlots",
            headers={
                "Content-Type": "application/json",
                "Authorization": "OAuth {}".format(yappy_token)
            },
            json={
                "betas_regexps": yappy_name,
                "allocated": True
            }
        )
        if not r.raise_for_status():
            logger.info("[INFO] Data from Yappy received")
            logger.info("[INFO] Yappy answer: {}".format(json.dumps(r.json())))
            for beta in r.json()["betaSlots"]:
                if beta["betaName"] == yappy_name:
                    hosts = beta["typeToSlots"][beta_type]["hosts"]
                    logger.info("[INFO] Found hosts: {}".format(", ".join(hosts)))
                    return hosts
            return []
