from sandbox.projects.hollywood.common.const import HollywoodConsts


deploy_settings = {
    HollywoodConsts.COMMON_SHARD: {
        "run_tests": True
    },
    HollywoodConsts.GENERAL_CONVERSATION_SHARD: {}
}

default_deploy_configs = {
    HollywoodConsts.COMMON_SHARD: {
        "communication": {
            "cluster": "locke",
            "cypress_dir": "//home/alice/hollywood_fast_data/common"
        },
        "deploy": {
            "dependencies": {
                "hollywood_prestable": {
                    "activate": [
                        {
                            "action": "prepare",
                            "name": "hollywood_sas"
                        },
                        {
                            "action": "prepare",
                            "name": "hollywood_vla"
                        },
                        {
                            "action": "prepare",
                            "name": "hollywood_hamster"
                        }
                    ]
                },
                "hollywood_sas": {
                    "activate": [
                        {
                            "action": "activate",
                            "name": "hollywood_prestable"
                        }
                    ]
                },
                "hollywood_vla": {
                    "activate": [
                        {
                            "action": "activate",
                            "name": "hollywood_sas"
                        }
                    ]
                },
                "hollywood_hamster": {
                    "activate": [
                        {
                            "action": "activate",
                            "name": "hollywood_vla"
                        }
                    ]
                }
            },
            "only_prepare": False
        },
        "services": {
            "hollywood_prestable": {
                "activate": {
                    "degrade_level": 0.15,
                    "failed_retry_delay": 300,
                    "retry_delay": 120,
                    "stop_degrade_level": 0.15
                },
                "prepare": {
                    "degrade_level": 1,
                    "failed_retry_delay": 300,
                    "retry_delay": 120
                }
            },
            "hollywood_sas": {
                "activate": {
                    "degrade_level": 0.15,
                    "failed_retry_delay": 300,
                    "retry_delay": 120,
                    "stop_degrade_level": 0.15
                },
                "prepare": {
                    "degrade_level": 1,
                    "failed_retry_delay": 300,
                    "retry_delay": 120
                }
            },
            "hollywood_vla": {
                "activate": {
                    "degrade_level": 0.15,
                    "failed_retry_delay": 300,
                    "retry_delay": 120,
                    "stop_degrade_level": 0.15
                },
                "prepare": {
                    "degrade_level": 1,
                    "failed_retry_delay": 300,
                    "retry_delay": 120
                }
            },
            "hollywood_hamster": {
                "activate": {
                    "degrade_level": 0.15,
                    "failed_retry_delay": 300,
                    "retry_delay": 120,
                    "stop_degrade_level": 0.15
                },
                "prepare": {
                    "degrade_level": 1,
                    "failed_retry_delay": 300,
                    "retry_delay": 120
                }
            }
        },
        "solomon": {
            "project": "hollywood",
            "cluster": "hollywood_prod",
            "service": "hollywood_fast_data"
        }
    },

    HollywoodConsts.GENERAL_CONVERSATION_SHARD: {
        "communication": {
            "cluster": "locke",
            "cypress_dir": "//home/alice/hollywood_fast_data/general_conversation"
        },
        "deploy": {
            "dependencies": {
                "general-conversation-ru-protocol-sas-prestable": {
                    "activate": [
                        {
                            "action": "prepare",
                            "name": "general-conversation-ru-protocol-sas-prestable"
                        },
                        {
                            "action": "prepare",
                            "name": "general-conversation-ru-protocol-sas"
                        },
                        {
                            "action": "prepare",
                            "name": "general-conversation-ru-protocol-vla"
                        }
                    ]
                },
                "general-conversation-ru-protocol-sas": {
                    "activate": [
                        {
                            "action": "activate",
                            "name": "general-conversation-ru-protocol-sas-prestable"
                        }
                    ]
                },
                "general-conversation-ru-protocol-vla": {
                    "activate": [
                        {
                            "action": "activate",
                            "name": "general-conversation-ru-protocol-sas"
                        }
                    ]
                }
            },
            "only_prepare": False
        },
        "services": {
            "general-conversation-ru-protocol-sas-prestable": {
                "activate": {
                    "degrade_level": 0.15,
                    "failed_retry_delay": 300,
                    "retry_delay": 120,
                    "stop_degrade_level": 0.15
                },
                "prepare": {
                    "degrade_level": 1,
                    "failed_retry_delay": 300,
                    "retry_delay": 120
                }
            },
            "general-conversation-ru-protocol-sas": {
                "activate": {
                    "degrade_level": 0.15,
                    "failed_retry_delay": 300,
                    "retry_delay": 120,
                    "stop_degrade_level": 0.15
                },
                "prepare": {
                    "degrade_level": 1,
                    "failed_retry_delay": 300,
                    "retry_delay": 120
                }
            },
            "general-conversation-ru-protocol-vla": {
                "activate": {
                    "degrade_level": 0.15,
                    "failed_retry_delay": 300,
                    "retry_delay": 120,
                    "stop_degrade_level": 0.15
                },
                "prepare": {
                    "degrade_level": 1,
                    "failed_retry_delay": 300,
                    "retry_delay": 120
                }
            }
        },
        "solomon": {
            "project": "hollywood",
            "cluster": "hollywood_general_conversation",
            "service": "hollywood_fast_data"
        }
    }
}

default_hamster_deploy_configs = {
    HollywoodConsts.COMMON_SHARD: {
        "communication": {
            "cluster": "locke",
            "cypress_dir": "//home/alice/hollywood_fast_data/common"
        },
        "deploy": {
            "dependencies": {
            },
            "only_prepare": False
        },
        "services": {
            "hollywood_hamster": {
                "activate": {
                    "degrade_level": 0.15,
                    "failed_retry_delay": 300,
                    "retry_delay": 120,
                    "stop_degrade_level": 0.15
                },
                "prepare": {
                    "degrade_level": 1,
                    "failed_retry_delay": 300,
                    "retry_delay": 120
                }
            }
        },
        "solomon": {
            "project": "hollywood",
            "cluster": "hollywood_hamster",
            "service": "hollywood_fast_data"
        }
    }
}
