from sandbox.projects.home.build.buildagent import BuildHomeBuildagentLxc, MordaRepoInfo
from sandbox.projects.sandbox.sandbox_lxc_image import SandboxLxcImage, UbuntuRelease
from sandbox.projects.home.resources import HomeTrustyBuildagentLxc


CUSTOM_REPOS = ['deb http://yandex-trusty.dist.yandex.ru/yandex-trusty stable/all/',
                'deb http://yandex-trusty.dist.yandex.ru/yandex-trusty stable/$(ARCH)/',
                'deb http://search-kernel.dist.yandex.ru/search-kernel stable/all/',
                'deb http://search-kernel.dist.yandex.ru/search-kernel stable/$(ARCH)/',
                'deb http://common.dist.yandex.ru/common stable/all/',
                'deb http://common.dist.yandex.ru/common stable/$(ARCH)/',
                'deb http://dist.yandex.ru/morda-trusty unstable/amd64/',
                'deb http://dist.yandex.ru/morda-trusty unstable/all/']


class BuildHomeTrustyBuildagentLxc(BuildHomeBuildagentLxc):

    class Parameters(BuildHomeBuildagentLxc.Parameters):
        description = "Build home trusty buildagent lxc"
        ubuntu_release = SandboxLxcImage.Parameters.ubuntu_release(default=UbuntuRelease.TRUSTY)
        resource_type = SandboxLxcImage.Parameters.resource_type(default=HomeTrustyBuildagentLxc.name)
        custom_repos = SandboxLxcImage.Parameters.custom_repos(default='\n'.join(CUSTOM_REPOS))

    def get_repos(self):
        return [
            MordaRepoInfo('git@github.yandex-team.ru:morda/tune.git', 'release')
        ]
