from sandbox.projects.home.build.buildagent import BuildHomeBuildagentLxc, MordaRepoInfo
from sandbox.projects.sandbox.sandbox_lxc_image import SandboxLxcImage, UbuntuRelease
from sandbox.projects.home.resources import HomeXenialBuildagentLxc


CUSTOM_REPOS = ['deb http://morda-xenial.dist.yandex.ru/morda-xenial unstable/$(ARCH)/',
                'deb http://morda-xenial.dist.yandex.ru/morda-xenial unstable/all/',
                'deb http://yandex-xenial.dist.yandex.ru/yandex-xenial stable/all/',
                'deb http://yandex-xenial.dist.yandex.ru/yandex-xenial stable/$(ARCH)/',
                'deb http://yandex-xenial.dist.yandex.ru/yandex-xenial unstable/all/',
                'deb http://yandex-xenial.dist.yandex.ru/yandex-xenial unstable/$(ARCH)/',
                'deb http://search-kernel.dist.yandex.ru/search-kernel stable/all/',
                'deb http://search-kernel.dist.yandex.ru/search-kernel stable/$(ARCH)/',
                'deb http://common.dist.yandex.ru/common        stable/all/',
                'deb http://common.dist.yandex.ru/common        stable/$(ARCH)/']


class BuildHomeXenialBuildagentLxc(BuildHomeBuildagentLxc):

    class Parameters(BuildHomeBuildagentLxc.Parameters):
        description = "Build home xenial buildagent lxc"
        ubuntu_release = SandboxLxcImage.Parameters.ubuntu_release(default=UbuntuRelease.XENIAL)
        resource_type = SandboxLxcImage.Parameters.resource_type(default=HomeXenialBuildagentLxc.name)
        custom_repos = SandboxLxcImage.Parameters.custom_repos(default='\n'.join(CUSTOM_REPOS))

    def get_repos(self):
        return [
            MordaRepoInfo('https://github.yandex-team.ru/morda/main.git', 'dev', ['/', '/tmpl/skins', '/tmpl']),
            MordaRepoInfo('https://github.yandex-team.ru/morda/portal-hbf.git'),
            MordaRepoInfo('git@github.yandex-team.ru:morda/admin.git'), # private
            MordaRepoInfo('https://github.yandex-team.ru/morda/export-puller.git'),
            MordaRepoInfo('https://github.yandex-team.ru/morda/export-pusher.git'),
            MordaRepoInfo('https://github.yandex-team.ru/morda/morda-syslog.git'),
            MordaRepoInfo('https://github.yandex-team.ru/morda/morda-xs.git')
        ]
