import sandbox.sandboxsdk.parameters as sb_params
import sandbox.common.types.task as ctt
from sandbox.projects.common.build import YaPackage
from sandbox.projects.common.nanny import nanny
from sandbox.projects.common.build import parameters as build_parameters
from sandbox.projects.common.nanny.nanny import StartrekTicketIdsParameter


class HomeYaPackage(nanny.ReleaseToNannyTask, YaPackage.YaPackage):
    """
        Task for creating tarball packages using 'ya package'
    """
    type = 'HOME_YA_PACKAGE'

    class HomePackagesParameter(YaPackage.PackagesParameter):
        default_value = None

    class AutoreleaseParameter(sb_params.SandboxSelectParameter):
        name = 'auto_release'
        description = 'Auto-release'
        choices = [('-', '-')]

        for status in [
                ctt.ReleaseStatus.TESTING,
                ctt.ReleaseStatus.UNSTABLE,
                ctt.ReleaseStatus.PRESTABLE,
                ctt.ReleaseStatus.STABLE]:

            choices.append((status, status))

        default_value = '-'
        required = False

    input_parameters = (
        YaPackage.parameters.ArcadiaUrl,
        HomePackagesParameter,
        YaPackage.ResourceTypeParameter,
        StartrekTicketIdsParameter
    )

    def get_context_override(self):
        return {
            YaPackage.PackageTypeParameter.name: YaPackage.TARBALL,
            YaPackage.StripBinariesParameter.name: True,
            YaPackage.UseNewFormatParameter.name: True,
            build_parameters.CheckoutParameter.name: True,
            YaPackage.parameters.BuildType.name: YaPackage.RELEASE
        }

    def _populate_context(self):
        """Populate context using YaPackage defaults and our defaults."""
        input_parameters_names = set(parameter.name for parameter in self.input_parameters)
        for parameter in YaPackage.YaPackage.input_parameters:
            if parameter.name not in input_parameters_names:
                self.ctx[parameter.name] = parameter().default_value
        self.ctx.update(self.get_context_override())

    def on_enqueue(self):
        self._populate_context()
        YaPackage.YaPackage.on_enqueue(self)

    def on_success(self):
        YaPackage.YaPackage.on_success(self)
        if self.ctx['auto_release'] != '-':
            self.on_release(dict(release_status=self.ctx['auto_release']))

__Task__ = HomeYaPackage
