import logging
from sandbox.sdk2.helpers import subprocess as sp


def rewriteVersions(rootDir, staticVersion, skinsVersion):
    logging.info('Rewriting static version to "%s"', staticVersion)

    versionFile = open(rootDir + '/tmpl/static_version.js', 'w')
    versionFile.write('home.staticVersion="' + staticVersion + '";\n')
    versionFile.close()

    versionFile = open(rootDir + '/lib/auto/static_version.pm', 'w')
    versionFile.write("package auto::static_version;\nour $staticVersion = '" + staticVersion + "';\n")
    versionFile.close()

    if skinsVersion:
        logging.info('Rewriting skins version to "%s"', skinsVersion)

        versionFile = open(rootDir + '/tmpl/skins/skins_version.js', 'w')
        versionFile.write('home.skinsVersion = "' + skinsVersion + '";\n')
        versionFile.close()

        versionFile = open(rootDir + '/lib/auto/skins_version.pm', 'w')
        versionFile.write("package auto::skins_version;\nour $skinsVersion = '" + skinsVersion + "';\n")
        versionFile.close()


def rewriteStaticUrls(root_dir, what, replacement):
    logging.info('Rewriting urls "%s" to "%s"', what, replacement)
    sed_cmd = 'sed -i "s!{}!{}!g"'.format(what, replacement)
    cmd = 'find ' + root_dir + ' -type f -a \\( \
        -name "*.css" -o \
        -name "*.js" -o \
        -name "*.html" -o \
        -name "*.json" \
    \\) -print0 | xargs -0 ' + sed_cmd

    status = sp.Popen(cmd, shell=True).wait()
    if status != 0:
        raise Exception("Failed to perform '{}'".format(cmd))

def getPotatoUrl(repo='morda/main', service='nanny'):
    return 'https://webhooks.potato.yandex.net/webhooks/github-enterprise/{repo}/service/{serviceName}'.format(
        repo=repo,
        serviceName=service
        )
