from sandbox.projects.sandbox.sandbox_lxc_image import SandboxLxcImage, UbuntuRelease
from sandbox import sdk2
import sandbox.common.types.misc as ctm


CUSTOM_REPOS = ['deb http://yandex-trusty.dist.yandex.ru/yandex-trusty stable/all/',
                'deb http://yandex-trusty.dist.yandex.ru/yandex-trusty stable/$(ARCH)/',
                'deb http://search-kernel.dist.yandex.ru/search-kernel stable/all/',
                'deb http://search-kernel.dist.yandex.ru/search-kernel stable/$(ARCH)/',
                'deb http://common.dist.yandex.ru/common stable/all/',
                'deb http://common.dist.yandex.ru/common stable/$(ARCH)/']


CUSTOM_PACKAGES = ['git',
                   'python2.7',
                   'python-pip',
                   'python-virtualenv',
                   'python-dev',
                   'libxml2-dev',
                   'libxslt1-dev',
                   'checkinstall',
                   'libreadline-gplv2-dev',
                   'libncursesw5-dev',
                   'libssl-dev',
                   'libsqlite3-dev',
                   'tk-dev',
                   'libgdbm-dev',
                   'libc6-dev',
                   'libbz2-dev',
                   'build-essential',
                   'python-software-properties',
                   'software-properties-common',
                   'wget',
                   'curl']


CUSTOM_SCRIPT = []


class BuildHomePythonLxc(SandboxLxcImage):

    class Requirements(SandboxLxcImage.Requirements):
        dns = ctm.DnsType.DNS64

    class Parameters(SandboxLxcImage.Parameters):
        description = 'Build LXC container for home python tests'
        test_result_lxc = SandboxLxcImage.Parameters.test_result_lxc(default=True)
        custom_image = SandboxLxcImage.Parameters.custom_image(default=True)
        ubuntu_release = SandboxLxcImage.Parameters.ubuntu_release(default=UbuntuRelease.TRUSTY)
        custom_repos = SandboxLxcImage.Parameters.custom_repos(default='\n'.join(CUSTOM_REPOS))
        custom_packages = SandboxLxcImage.Parameters.custom_packages(default=' '.join(CUSTOM_PACKAGES))
        custom_script = SandboxLxcImage.Parameters.custom_script(default='\n'.join(CUSTOM_SCRIPT))
        python_requirements = sdk2.parameters.String('Python requirements', multiline=True)

    def cook_image(self, current_dir):
        SandboxLxcImage.cook_image(self, current_dir)
        if self.Parameters.python_requirements:
            self.execute('pip install {}'.format(' '.join(self.Parameters.python_requirements.splitlines())), True)
