from sandbox import sdk2

import os
import pathlib2
from sandbox.sdk2.helpers import subprocess as sp
from sandbox.projects.home.common.debuild import HomeDebuilderTask
from sandbox.projects.home.resources import HomeXenialBuildagentLxc
from sandbox.projects.trendbox_ci.beta.managers.vault import VaultManager
from sandbox.projects.common.nanny import nanny
from sandbox import sandboxsdk
from sandbox.common import config as common_config
import sandbox.common.types.task as ctt
import sandbox.common.types.resource as ctr
import logging


class BuildEtherUnstable(HomeDebuilderTask):

    class Parameters(HomeDebuilderTask.Parameters):
        description = 'Build portal-ether unstable perl release'

        container = HomeDebuilderTask.Parameters.container(resource_type=HomeXenialBuildagentLxc, platform='linux_ubuntu_16.04_xenial')
        git_repo = HomeDebuilderTask.Parameters.git_repo(default='git@github.yandex-team.ru:morda/main.git')
        dist_repo = HomeDebuilderTask.Parameters.dist_repo(default_value='morda-xenial')
        branch = sdk2.parameters.String('Branch or Tag', required=True)
        to_dupload = HomeDebuilderTask.Parameters.to_dupload(default=False)
        create_tarball = HomeDebuilderTask.Parameters.create_tarball(default=False)
        debticket = HomeDebuilderTask.Parameters.debticket(default=False)

    def get_changelog(self):
        return ''

    def before_build(self):
        os.environ['SANDBOX_SYNCHROPHAZOTRON_PATH'] = str(self.synchrophazotron)
        os.environ['TRENDBOX_SYNCHROPHAZOTRON'] = str(self.synchrophazotron)
        os.environ['GSID'] = "SB:TRENDBOX_CI_BUILD_BETA:0 SB:TRENDBOX_CI_JOB_BETA:{}".format(self.id);
        os.environ['npm_config_cache'] = os.path.join(self.Context.root_dir, '.npmcache')
        logging.info("synchrophazotron path: {}".format(os.environ['TRENDBOX_SYNCHROPHAZOTRON']))
        logging.info("npm_config_cache path: {}".format(os.environ['npm_config_cache']))

    def move_repo(self):
        with sdk2.helpers.ProcessLog(self, logger=logging.getLogger("git_checkout")) as pl:
            base = os.path.basename(self.Context.repo_dir)
            dirname = os.path.dirname(self.Context.repo_dir)
            status = sp.Popen('cp -r {} {}'.format(base, self.path(base)),
                              shell=True,
                              stdout=pl.stdout,
                              stderr=sp.STDOUT,
                              cwd=dirname).wait()
            if status != 0:
                raise Exception('Failed to move repo {} {} -> {}'.format(dirname, base, self.path(base)))

        self.Context.repo_dir = str(self.path(base))
        self.Context.root_dir = str(self.path())

        self.Context.project_dir = self.Context.repo_dir
        if self.Parameters.project_dir:
            self.Context.project_dir = os.path.join(self.Context.project_dir, self.Parameters.project_dir)

        self.Context.deb_dir = os.path.basename(self.Context.project_dir)


    def on_execute(self):
        with self.memoize_stage.git_clone:
            self.git_clone()

        with self.memoize_stage.mv_repo:
            self.move_repo()

        self.before_build()
        build_command = 'make unstablerelease RELEASE_TYPE=unstable TAG={}'.format(self.Parameters.branch)

        vault_manager = VaultManager(self)
        vault_envs = vault_manager.get_all_vault_env().items()

        with sdk2.helpers.ProcessLog(self, logger=logging.getLogger("build")) as pl:
            with sandboxsdk.ssh.Key(self, "HOME", "home_buildfarm"):
                status = sp.Popen(build_command,
                                  shell=True,
                                  stdout=pl.stdout,
                                  stderr=sp.STDOUT,
                                  cwd=self.Context.project_dir,
                                  env=dict(os.environ.items() + vault_envs)).wait()
                if status != 0:
                    raise Exception('Failed to build deb')

    def on_save(self):
        pass

    def on_release(self, additional_parameters):
        pass
