from sandbox.sandboxsdk import environments
from sandbox import sdk2
from sandbox.sandboxsdk import process
import os

# MORDA_DUTY_CHANGER


class MordaDutyChanger(sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        timetable = sdk2.parameters.String('Timetable', default=None)
        change_from = sdk2.parameters.String('ChangeFrom', default=None)
        change_to = sdk2.parameters.String('ChangeTo', default=None)
        robot_name = sdk2.parameters.String('RobotName', default='robot-morda-duty')
        debug = sdk2.parameters.String('Debug', default=None)

    def on_execute(self):
        robot_morda_duty_token = sdk2.Vault.data(self.Parameters.robot_name + '-token')
        robot_morda_duty_uuid = '85FD18EA-A0FF-5AB3-69C7-864B3F2DA59A'
        if self.Parameters.robot_name == 'robot-morda-duty-aux':
            robot_morda_duty_uuid = '55C14043-F775-6B35-52F3-F65FEDB4A490'
        with environments.VirtualEnvironment() as venv:
            venv.pip("setuptools==41.4.0")
            venv.pip("urllib3==1.24.3")
            venv.pip('requests')
            cmd = [
                venv.executable, os.path.dirname(__file__) + '/script.py',
                "--timetable", self.Parameters.timetable,
                "--change_from", self.Parameters.change_from,
                "--change_to", self.Parameters.change_to,
                "--token", robot_morda_duty_token,
                "--uuid", robot_morda_duty_uuid,
            ]
            if self.Parameters.debug:
                cmd.append("--debug")
            process.run_process(cmd, log_prefix='script')
