# -*- coding: utf-8 -*-

import logging
import requests
import sys
import datetime
import argparse


class Changer(object):
    def __init__(self, token, uuid):
        self.oauth = token
        """ How to get UUID
        curl -i -X GET -H'Authorization: OAuth {token}' -H'Content-Type: application/json' 'https://telegraph.yandex-team.ru/api/v3/cucm/translation_pattern/pattern/87830'
        where 87830 is a phone number
        """
        self.telegraph = 'https://telegraph.yandex.net/api/v3/cucm/translation_pattern/uuid/' + uuid

    def get_number(self):
        res = requests.get(
            self.telegraph,
            headers={
                'Authorization': 'OAuth {0}'.format(self.oauth),
                'Content-Type': 'application/json'
            },
            verify=False,
            timeout=3
        )
        data = res.json() or {}
        logging.debug(data)

        if data.get('error'):
            return
        return data.get('result', {}).get('calledPartyTransformationMask')

    def set_number(self, number):
        res = requests.put(
            self.telegraph,
            headers={
                'Authorization': 'OAuth {0}'.format(self.oauth),
                'Content-Type': 'application/json'
            },
            json={"calledPartyTransformationMask": str(number)},
            verify=False,
            timeout=3
        )
        data = res.json() or {}
        logging.debug(data)


def set_logger(debug):
    logger = logging.getLogger()
    if debug:
        logger.setLevel(logging.DEBUG)
    else:
        logger.setLevel(logging.INFO)
    logger.handlers = [logging.StreamHandler(sys.stderr)]


if __name__ == "__main__":
    arg_parser = argparse.ArgumentParser(description='Report about pushed for certain did')
    arg_parser.add_argument('--debug', '-d', action='store_true', help='Add debug messages to log.')
    arg_parser.add_argument('--timetable', action='store', help='did')
    arg_parser.add_argument('--change_from', action='store', help='did')
    arg_parser.add_argument('--change_to', action='store', help='did')
    arg_parser.add_argument('--token', action='store', help='token')
    arg_parser.add_argument('--uuid', action='store', help='uuid')
    args = arg_parser.parse_args()

    assert args.timetable
    assert args.change_from
    assert args.change_to

    set_logger(debug=args.debug)
    logging.debug('Args of cli: {}'.format(args))

    hour = datetime.datetime.time(datetime.datetime.now()).strftime("%H")
    logging.debug('Hour is {}'.format(hour))

    if hour >= args.change_from and hour <= args.change_to:
        timetable = args.timetable.split(',')
        logging.debug('Timetable = {}'.format(timetable))

        weekday = datetime.datetime.today().weekday()
        logging.debug('Today is {}'.format(weekday))

        name_phone = timetable[weekday]
        if name_phone:
            _, phone = name_phone.split(':')
            assert phone

            logging.debug('Phone must be {}'.format(phone))

            c = Changer(token=args.token, uuid=args.uuid)
            current_phone = c.get_number()

            if phone != current_phone:
                logging.debug('Try to set')
                c.set_number(phone)
