from sandbox.projects.common.nanny import nanny
from sandbox import sdk2
from sandbox.sandboxsdk.svn import Arcadia
from sandbox.projects.home.resources import PumpiApp
import tarfile

# MORDA_PUMPI_APP


class MordaPumpiApp(nanny.ReleaseToNannyTask2, sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        debug = sdk2.parameters.String('Debug', default=None)
        auto_release = sdk2.parameters.String('Auto_release', default=None)
        arcadia_patch = sdk2.parameters.String('Arcadia patch', default=None)

    def on_execute(self):
        resource = sdk2.ResourceData(PumpiApp(self, "Archive", "pumpi.tar.gz"))
        resource = resource  # dirty hack for arcadia check
        REPO_PATH = "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/portal/pumpi"
        Arcadia.checkout(REPO_PATH, 'pumpi', revision=None)
        if self.Parameters.arcadia_patch:
            Arcadia.apply_patch('pumpi', self.Parameters.arcadia_patch, self.path())

        with tarfile.open('pumpi.tar.gz', mode='w:gz') as tf:
            tf.add('pumpi')
            tf.close()

    def on_success(self, prev_status):
        sdk2.Task.on_success(self, prev_status)

        if self.Parameters.auto_release:
            nanny.ReleaseToNannyTask2.on_release(self, dict(
                releaser=self.author,
                release_status='testing',
                release_subject="New application version",
                email_notifications=dict(to=[], cc=[]),
                release_comments='HOME-41955. morda pumpi app',
            ))
