from sandbox.projects.common.nanny import nanny
from sandbox import sdk2
from sandbox.sandboxsdk.svn import Arcadia
from sandbox.projects.home.resources import StarlogApp
import tarfile

# MORDA_STARLOG_APP


class MordaStarlogApp(nanny.ReleaseToNannyTask2, sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        debug = sdk2.parameters.String('Debug', default=None)
        auto_release = sdk2.parameters.String('Auto_release', default=None)

    def on_execute(self):
        resource = sdk2.ResourceData(StarlogApp(self, "Archive", "starlog.tar.gz"))
        resource = resource  # dirty hack for arcadia check
        REPO_PATH = "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/home/starlog"
        Arcadia.checkout(REPO_PATH, 'starlog', revision=None)

        with tarfile.open('starlog.tar.gz', mode='w:gz') as tf:
            tf.add('starlog')
            tf.close()

    def on_success(self, prev_status):
        sdk2.Task.on_success(self, prev_status)

        if self.Parameters.auto_release:
            nanny.ReleaseToNannyTask2.on_release(self, dict(
                releaser=self.author,
                release_status='stable',
                release_subject="New application version",
                email_notifications=dict(to=[], cc=[]),
                release_comments='morda starlog app',
            ))
