# -*- coding: utf-8 -*-

import json
import logging
import re
import requests
import datetime, time

from sandbox import sdk2
from sandbox.sdk2 import yav
from sandbox.sdk2 import parameters
import sandbox.projects.common.environments as env

ST_API_URL       = 'https://st-api.yandex-team.ru/v2/issues/_search'
YQL_API_BASE_URL = 'https://yql.yandex.net/api/v2/'
TEST_QUERY       = 'Assignee: alexeybabenko, danildudin, holygun, ybibibaz, slindgre, onlymiind, adubinkin, thelostdes, kozunov, amyshkin, katuxa, stasyuk AND Components: !Дежурство AND Queue: HOME AND Tags: !"#flags" AND Tags: !"#notest" AND Tags: !"urelease:morda"  and Status: Closed and "Last Status Change": >= today() - 1month'
TEST_QUERY_1FEB  = 'Assignee: alexeybabenko, danildudin, holygun, ybibibaz, slindgre, onlymiind, adubinkin, thelostdes, kozunov, amyshkin, katuxa, stasyuk AND Components: !Дежурство AND Queue: HOME AND Tags: !"#flags" AND Tags: !"#notest" AND Tags: !"urelease:morda"  and Status: Closed and "Last Status Change": >= 01.02.2022'
team             = ['alexeybabenko', 'danildudin', 'holygun', 'ybibibaz', 'slindgre', 'onlymiind', 'adubinkin', 'thelostdes', 'kozunov', 'amyshkin', 'katuxa', 'stasyuk']
GOAL_VALUE       = 0.3


YQL_REQUEST_TEMPLATE_ADD_LEADERBOARD = """
USE hahn;
INSERT INTO 
    hahn.`home/morda/schema-tests/test_leaderboard`(date, name, tasks_num, coverage, goal)
VALUES
    (cast(DATE as Date), CAST("NAME" as String), CAST(TASKS_NUM as int32), CAST(COVERAGE as Double), CAST(GOAL as Double));
"""

YQL_REQUEST_TEMPLATE_ADD_TOTAL = """
USE hahn;
INSERT INTO 
    hahn.`home/morda/schema-tests/test_total`(date, name, tasks_num, coverage, goal)
VALUES
    (cast(DATE as Date), CAST("NAME" as String), CAST(TASKS_NUM as int32), CAST(COVERAGE as Double), CAST(GOAL as Double));
"""

YQL_REQUEST_TEMPLATE_ADD_LEADERBOARD_1FEB = """
USE hahn;
INSERT INTO 
    hahn.`home/morda/schema-tests/test_leaderboard_1feb`(date, name, tasks_num, coverage, goal)
VALUES
    (cast(DATE as Date), CAST("NAME" as String), CAST(TASKS_NUM as int32), CAST(COVERAGE as Double), CAST(GOAL as Double));
"""

YQL_REQUEST_TEMPLATE_ADD_TOTAL_1FEB = """
USE hahn;
INSERT INTO 
    hahn.`home/morda/schema-tests/test_total_1feb`(date, name, tasks_num, coverage, goal)
VALUES
    (cast(DATE as Date), CAST("NAME" as String), CAST(TASKS_NUM as int32), CAST(COVERAGE as Double), CAST(GOAL as Double));
"""


def get_yql_request_add(template, date, name, tasks_num, coverage):
    request = template
    request = re.sub(r'DATE', str(date), request)
    request = re.sub(r'NAME', str(name), request)
    request = re.sub(r'TASKS_NUM', str(tasks_num), request)
    request = re.sub(r'COVERAGE', str(coverage), request)
    request = re.sub(r'GOAL', str(GOAL_VALUE), request)
    return request

def get_tasks (query, tokens):
    st_token  = tokens['startrek']
    session = requests.Session()
    session.headers.update({
        'Authorization': "OAuth {}".format(st_token),
        'Content-Type': 'application/json',
    })
    request = {
        'query': query
    }

    all_tasks = []

    page_num = 1
    last_page_num = 99
    while page_num <= last_page_num:
        response = session.post(
            ST_API_URL + '?page=' + str(page_num),
            json=request
        )
        if response.status_code != 200:
            logging.info('Failed to create st task. Response status_code={}'.format(response.status_code))
            return None

        logging.info('Send ok! Response status_code={}'.format(response.status_code))
        logging.info(response.json())

        last_page_num = int(response.headers['X-Total-Pages'])
        page_num += 1

        all_tasks.extend(response.json())

    return all_tasks

def add_to_yt (template, date, name, tasks_num, coverage, tokens):
    token = tokens['yql']
    query = get_yql_request_add(template, date, name, tasks_num, coverage)
    logging.info(query)
    session = requests.Session()
    session.headers.update({
        'User-Agent': 'YQL Sandbox (RUN_YQL task)',
        'Authorization': "OAuth {}".format(token),
        'Content-Type': 'application/json',
    })
    request = {
        'content': query,
        'action': 'RUN',
        'type': 'SQLv1'
    }
    response = session.post(
        YQL_API_BASE_URL + 'operations',
        json=request
    )
    if response.status_code != 200:
        logging.info('Failed to send yql request. Response status_code={}'.format(response.status_code))
        return None
    else:
        logging.info('Send ok! Response status_code={}'.format(response.status_code))
        yql_id = response.json()['id']
        return yql_id

def calc_and_send(tasks, total_request, leader_request, tokens):
    results = {}
    total = {'tasks': 0, 'coverage': 0, 'ratio': 0}
    for member in team:
        results[member] = {'tasks': 0, 'coverage': 0, 'ratio': 0}

    for task in tasks:
        assignee = task['assignee']['id']
        print assignee
        coverage = task.get("60c725c3de2db0645cc06cae--testCoverage")
        total['tasks'] += 1
        if results.get(assignee) is not None:
            results[assignee]['tasks'] += 1
        if coverage is not None:
            total['coverage'] += coverage
            if results.get(assignee) is not None:
                results[assignee]['coverage'] += coverage


    for member in results:
        if results[member]['tasks'] > 0:
            results[member]['ratio'] = float(results[member]['coverage']) / float(results[member]['tasks'])

    if total['tasks'] > 0:
        total['ratio'] = float(total['coverage']) / float(total['tasks'])

    millisecond = datetime.datetime.now()
    date = int(time.mktime(millisecond.timetuple()) / 86400)

    logging.info('date: ')
    logging.info(date)

    add_to_yt (total_request, date, 'total', total['tasks'], total['ratio'], tokens)

    for member in results:
        add_to_yt (leader_request, date, member, results[member]['tasks'], results[member]['ratio'], tokens)


class MordaTasksTable(sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        test_query = sdk2.parameters.String('TEST_QUERY', default=TEST_QUERY)
        test_query_1feb = sdk2.parameters.String('TEST_QUERY_1FEB', default=TEST_QUERY_1FEB)

    class Requirements(sdk2.Requirements):
        cores = 1
        ram = 512
        disk_space = 100

    def on_execute(self):
        tokens = {}
        secret = yav.Secret("sec-01ctre6sae7k58g37x5yab2z4q")
        tokens['startrek']  = secret.data()["STARTREK_OAUTH_TOKEN"]
        tokens['yql']  = secret.data()["YQL_OAUTH_TOKEN"]
        
        tasks = get_tasks(self.Parameters.test_query, tokens)
        tasks_1feb = get_tasks(self.Parameters.test_query_1feb, tokens)

        calc_and_send(tasks, YQL_REQUEST_TEMPLATE_ADD_TOTAL, YQL_REQUEST_TEMPLATE_ADD_LEADERBOARD, tokens)
        calc_and_send(tasks_1feb, YQL_REQUEST_TEMPLATE_ADD_TOTAL_1FEB, YQL_REQUEST_TEMPLATE_ADD_LEADERBOARD_1FEB, tokens)
