from sandbox.sandboxsdk import environments
from sandbox import sdk2
from sandbox.sandboxsdk import process
import os

# MORDA_YASM_ALERTS


class MordaYasmAlerts(sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        level = sdk2.parameters.String('level', default='fatal')

    def on_execute(self):
        with environments.VirtualEnvironment() as venv:
            venv.pip('requests')
            cmd = [
                venv.executable, os.path.dirname(__file__) + '/script.py',
                "--level", self.Parameters.level,
            ]
            process.run_process(cmd, log_prefix='script')
