# -*- coding: utf-8 -*-
import logging
import requests
import json
import sys
import datetime
import argparse


def run(level='fatal'):
    thresholds = {
        'awaps':                        (2,  5),
        'blackbox':                     (2,  5),
        'yabs':                         (2,  5),
        'atom':                         (2,  5),
        'mail_settings':                (20, 30),
        'personal_request_batch_1':     (20, 30),
        'pers_tv':                      (8, 10)
    }

    alert_json_template = '''
    {
	"name": "portal.wfront.subreqfail.%s",
	"signal": "%s",
	"mgroups": [
	    "CON"
	],
	"tags": {
	    "itype": [
		"wfront"
	    ],
	    "tier": [
		"self"
	    ]
	},
	"warn": [
	    %s,
	    %s
	],
	"crit": [
	    %s,
	    null
	],
	"juggler_check":{
	    "host": "yasm_portal.wfront",
	    "service": "subreqfail.%s",
	    "flaps": {
		"stable": 120,
		"critical":600
		},
	    "ttl": 900,
	    "aggregator": "logic_or",
	    "refresh_time": 10,
	    "notifications": [{
		"template_name": "golem",
		"template_kwargs": {}
	    }]

	}
    }
    '''

    signals = []
    sparse_signals = None

    r = requests.get('https://yasm.yandex-team.ru/srvambry/tmpl/panels/render_json/morda_lights_room', verify=True, timeout=10)
    content = json.loads(r.content)

    for i in content['charts']:
        if i['id'] == '5':
            signals = i['signals']
        if i['id'] == '28':
            sparse_signals = i['signals']
        if i['id'] == '4':
            critical_signals = i['signals']

    if sparse_signals:
        signals = signals + sparse_signals

    if critical_signals:
        signals = signals + critical_signals
    for signal in signals:
        signal_name = signal['name']
        if level == 'fatal' and signal_name.index('fails_summ'):
            signal_name = signal_name.replace('fails_summ', 'fatal_summ')

        if signal['title'] in thresholds:
            data = alert_json_template % (signal['title'], signal_name, thresholds[signal['title']][0], thresholds[signal['title']][1], thresholds[signal['title']][1], signal['title'])
        else:
            data = alert_json_template % (signal['title'], signal_name, '15', '20', '20', signal['title'])
        r = requests.post('https://yasm.yandex-team.ru/srvambry/alerts/update?name=portal.wfront.subreqfail.{}'.format(signal['title']), data=data, verify=True, timeout=10)
        if r.status_code == 200:
            print "{}: alert portal.wfront.subreqfail.{} refreshed".format(datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S"), signal['title'])
        if r.status_code == 404:
            r = requests.post('https://yasm.yandex-team.ru/srvambry/alerts/create?name=portal.wfront.subreqfail.{}'.format(signal['title']), data=data, verify=True, timeout=10)
            print "{}: new alert portal.wfront.subreqfail.{} created".format(datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S"), signal['title'])


def set_logger(debug):
    logger = logging.getLogger()
    if debug:
        logger.setLevel(logging.DEBUG)
    else:
        logger.setLevel(logging.INFO)

    logger.handlers = [logging.StreamHandler(sys.stderr)]


if __name__ == '__main__':
    arg_parser = argparse.ArgumentParser(description='Report about pushed for certain did')
    arg_parser.add_argument('--debug', '-d', action='store_true', help='Add debug messages to log.')
    arg_parser.add_argument('--level', action='store', help='level (fatal, fails)')
    args = arg_parser.parse_args()

    set_logger(debug=args.debug)
    logging.info('args of cli: {}'.format(args))
    run(level=args.level)
