from sandbox.projects.common.build import YaPackage
from sandbox.projects.home.common.package import HomeYaPackage
from sandbox.projects.home.resources import PortalMordaAdminTarball
from sandbox.projects.common.nanny.nanny import StartrekTicketIdsParameter


class BuildPortalMordaAdmin(HomeYaPackage):
    type = 'BUILD_PORTAL_MORDA_ADMIN'

    class AutoreleaseParameter(HomeYaPackage.AutoreleaseParameter):
        default_value = 'testing'

    input_parameters = (
        YaPackage.parameters.ArcadiaUrl,
        AutoreleaseParameter,
        StartrekTicketIdsParameter
    )

    def get_context_override(self):
        context = HomeYaPackage.get_context_override(self)
        context[YaPackage.ResourceTypeParameter.name] = PortalMordaAdminTarball.name
        context[HomeYaPackage.HomePackagesParameter.name] = 'portal/admin/packages/portal-morda-admin/package.json'
        return context


__Task__ = BuildPortalMordaAdmin
