from sandbox import sdk2
import logging
from sandbox.sdk2.helpers import subprocess as sp
from sandbox.projects.home.common.debuild import HomeDebuilderTask, MordaTarballResource
from sandbox.projects.home.resources import PortalMordaExportPullerTarball, HomeXenialBuildagentLxc


class PortalMordaExportPullerResource(MordaTarballResource):

    def __init__(self, task, description=''):
        super(PortalMordaExportPullerResource, self).__init__(task, PortalMordaExportPullerTarball, description=description)

    def prepare_data(self):

        target_dir = 'export-puller'
        command = 'make tarball_data'
        with sdk2.helpers.ProcessLog(self, logger=logging.getLogger("create_portal_morda_export_puller_data")) as pl:
            status = sp.Popen(command, shell=True, stdout=pl.stdout, stderr=sp.STDOUT, cwd=self.task.Context.project_dir).wait()
            if status != 0:
                raise Exception('Failed to prepare tarball data')

            return self.task.Context.project_dir + '/tarball', target_dir


class BuildPortalMordaExportPuller(HomeDebuilderTask):

    class Parameters(HomeDebuilderTask.Parameters):
        description = 'Build portal-morda-export-puller'

        container = HomeDebuilderTask.Parameters.container(resource_type=HomeXenialBuildagentLxc, platform='linux_ubuntu_16.04_xenial')
        git_repo = HomeDebuilderTask.Parameters.git_repo(default='git@github.yandex-team.ru:morda/export-puller.git')
        dist_repo = HomeDebuilderTask.Parameters.dist_repo(default_value='morda-xenial')
        to_dupload = HomeDebuilderTask.Parameters.to_dupload(default=True)
        create_tarball = HomeDebuilderTask.Parameters.create_tarball(default=True)
        auto_release = HomeDebuilderTask.Parameters.auto_release(default='testing')

    def get_resources(self):
        return [
            PortalMordaExportPullerResource(self)
        ]
