from sandbox.projects.home.common.debuild import HomeDebuilderTask
from sandbox.projects.home.resources import HomeXenialBuildagentLxc


class BuildPortalMordaExportPusher(HomeDebuilderTask):

    class Parameters(HomeDebuilderTask.Parameters):
        description = 'Build portal-morda-export-pusher'

        container = HomeDebuilderTask.Parameters.container(resource_type=HomeXenialBuildagentLxc, platform='linux_ubuntu_16.04_xenial')
        git_repo = HomeDebuilderTask.Parameters.git_repo(default='git@github.yandex-team.ru:morda/export-pusher.git')
        dist_repo = HomeDebuilderTask.Parameters.dist_repo(default_value='morda-xenial')
        to_dupload = HomeDebuilderTask.Parameters.to_dupload(default=True)
        create_tarball = HomeDebuilderTask.Parameters.create_tarball(default=False)
        branch = HomeDebuilderTask.Parameters.branch('Branch', required=True, default_value='master')
