from sandbox import sdk2
import logging
from sandbox.sdk2.helpers import subprocess as sp
from sandbox.projects.home.common.debuild import HomeDebuilderTask, MordaFileResource, MordaTarballResource
from sandbox.projects.home.resources import HomeXenialBuildagentLxc, PortalMordaTrafficForecastTarball


class PortalMordaTrafficForecastResource(MordaTarballResource):

    def __init__(self, task, description=''):
        super(PortalMordaTrafficForecastResource, self).__init__(task, PortalMordaTrafficForecastTarball, description=description)

    def prepare_data(self):
        target_dir = 'traffic-forecast'
        command = 'make tarball_data'
        with sdk2.helpers.ProcessLog(self, logger=logging.getLogger("create_portal_morda_traffic_forecast_data")) as pl:
            status = sp.Popen(command, shell=True, stdout=pl.stdout, stderr=sp.STDOUT, cwd=self.task.Context.project_dir).wait()
            if status != 0:
                raise Exception('Failed to create resource data')

            return self.task.Context.project_dir + '/tarball', target_dir


class BuildPortalMordaTrafficForecast(HomeDebuilderTask):

    class Parameters(HomeDebuilderTask.Parameters):
        description = 'Build portal-morda-traffic-forecast'

        container = HomeDebuilderTask.Parameters.container(resource_type=HomeXenialBuildagentLxc, platform='linux_ubuntu_16.04_xenial')
        git_repo = HomeDebuilderTask.Parameters.git_repo(default='git@github.yandex-team.ru:morda/traffic-forecast.git')
        dist_repo = HomeDebuilderTask.Parameters.dist_repo(default_value='morda-xenial')
        to_dupload = HomeDebuilderTask.Parameters.to_dupload(default=False)
        create_tarball = HomeDebuilderTask.Parameters.create_tarball(default=True)
        branch = HomeDebuilderTask.Parameters.branch(default_value='master')
        auto_release = HomeDebuilderTask.Parameters.auto_release(default=False)

    def get_resources(self):
        return [
            PortalMordaTrafficForecastResource(self)
        ]
