from sandbox.projects.common.build import YaPackage
from sandbox.projects.home.common.package import HomeYaPackage
from sandbox.projects.home.resources import PortalMordaWboxdbTarball
from sandbox.projects.common.nanny.nanny import StartrekTicketIdsParameter


class BuildPortalMordaWboxdb(HomeYaPackage):
    type = 'BUILD_PORTAL_MORDA_WBOXDB'

    class AutoreleaseParameter(HomeYaPackage.AutoreleaseParameter):
        default_value = 'testing'

    input_parameters = (
        YaPackage.parameters.ArcadiaUrl,
        AutoreleaseParameter,
        StartrekTicketIdsParameter
    )

    def get_context_override(self):
        context = HomeYaPackage.get_context_override(self)
        context[YaPackage.ResourceTypeParameter.name] = PortalMordaWboxdbTarball.name
        context[HomeYaPackage.HomePackagesParameter.name] = 'portal/wboxdb/packages/portal-morda-wboxdb/package.json'
        return context


__Task__ = BuildPortalMordaWboxdb
