from sandbox import sdk2
import logging
from sandbox.sdk2.helpers import subprocess as sp
from sandbox.projects.home.common.debuild import HomeDebuilderTask, MordaTarballResource
from sandbox.projects.home.resources import PortalRssStorageTarball, HomeXenialBuildagentLxc


class PortalRssStorageResource(MordaTarballResource):

    def __init__(self, task, description=''):
        super(PortalRssStorageResource, self).__init__(task, PortalRssStorageTarball, description=description)

    def prepare_data(self):
        target_dir = 'rss-storage'
        command = 'make tarball_data'
        with sdk2.helpers.ProcessLog(self, logger=logging.getLogger("create_rss_storage_data")) as pl:
            status = sp.Popen(command, shell=True, stdout=pl.stdout, stderr=sp.STDOUT, cwd=self.task.Context.project_dir).wait()
            if status != 0:
                raise Exception('Failed to create resource data')

            return self.task.Context.project_dir + '/tarball', target_dir


class BuildPortalRssStorage(HomeDebuilderTask):

    class Parameters(HomeDebuilderTask.Parameters):
        description = 'Build rss-storage'

        container = HomeDebuilderTask.Parameters.container(resource_type=HomeXenialBuildagentLxc, platform='linux_ubuntu_16.04_xenial')
        git_repo = HomeDebuilderTask.Parameters.git_repo(default='https://github.yandex-team.ru/morda/portal-rss-widget-db.git')
        dist_repo = HomeDebuilderTask.Parameters.dist_repo(default_value='morda-xenial')
        to_dupload = HomeDebuilderTask.Parameters.to_dupload(default=False)
        create_tarball = HomeDebuilderTask.Parameters.create_tarball(default=True)
        make_debuild = sdk2.parameters.Bool('Make debuild', required=True, default=False)
        debticket = HomeDebuilderTask.Parameters.debticket(default=False)
        auto_release = HomeDebuilderTask.Parameters.auto_release(default='testing')
        branch = HomeDebuilderTask.Parameters.branch('Branch', required=True, default_value='master')

    def get_resources(self):
        return [
            PortalRssStorageResource(self)
        ]
