from sandbox import sdk2
import logging
from sandbox.sdk2.helpers import subprocess as sp
from sandbox.projects.home.common.debuild import HomeDebuilderTask, MordaTarballResource
from sandbox.projects.home.resources import PortalXivaTarball, HomeXenialBuildagentLxc


class PortalXivaResource(MordaTarballResource):

    def __init__(self, task, description=''):
        super(PortalXivaResource, self).__init__(task, PortalXivaTarball, description=description)

    def prepare_data(self):
        target_dir = 'portal-xiva'
        command = 'make tarball_data'
        with sdk2.helpers.ProcessLog(self, logger=logging.getLogger("create_portal_xiva_data")) as pl:
            status = sp.Popen(command, shell=True, stdout=pl.stdout, stderr=sp.STDOUT, cwd=self.task.Context.project_dir).wait()
            if status != 0:
                raise Exception('Failed to create resource data')

            return self.task.Context.project_dir + '/tarball', target_dir


class BuildPortalXiva(HomeDebuilderTask):

    class Parameters(HomeDebuilderTask.Parameters):
        description = 'Build portal-xiva'

        container = HomeDebuilderTask.Parameters.container(resource_type=HomeXenialBuildagentLxc, platform='linux_ubuntu_16.04_xenial')
        git_repo = HomeDebuilderTask.Parameters.git_repo(default='https://github.yandex-team.ru/morda/xiva.git')
        dist_repo = HomeDebuilderTask.Parameters.dist_repo(default_value='morda-xenial')
        to_dupload = HomeDebuilderTask.Parameters.to_dupload(default=False)
        create_tarball = HomeDebuilderTask.Parameters.create_tarball(default=True)
        debticket = HomeDebuilderTask.Parameters.debticket(default=False)
        auto_release = HomeDebuilderTask.Parameters.auto_release(default='testing')
        make_debuild = HomeDebuilderTask.Parameters.make_debuild(default=False)
        branch = HomeDebuilderTask.Parameters.branch('Branch', required=True, default_value='master')

    def get_resources(self):
        return [
            PortalXivaResource(self)
        ]
