from sandbox.projects.common.build import YaPackage
from sandbox.projects.home.common.package import HomeYaPackage
from sandbox.projects.home.resources import PortalAvocadoTarball
from sandbox.projects.common.nanny.nanny import StartrekTicketIdsParameter


class BuildPortalAvocado(HomeYaPackage):
    """
        Build Go binary for Avocado Apphost servant
    """
    type = 'BUILD_AVOCADO'

    class AutoreleaseParameter(HomeYaPackage.AutoreleaseParameter):
        default_value = 'testing'

    input_parameters = (
        YaPackage.parameters.ArcadiaUrl,
        AutoreleaseParameter,
        StartrekTicketIdsParameter
    )

    def get_context_override(self):
        context = HomeYaPackage.get_context_override(self)
        context[YaPackage.ResourceTypeParameter.name] = PortalAvocadoTarball.name
        context[HomeYaPackage.HomePackagesParameter.name] = 'portal/morda-go/packages/avocado.json'
        return context


__Task__ = BuildPortalAvocado
