from sandbox.projects.common.build import YaPackage
from sandbox.projects.home.common.package import HomeYaPackage
from sandbox.projects.home.resources import PortalCacherTarball
from sandbox.projects.common.nanny.nanny import StartrekTicketIdsParameter


class BuildPortalCacher(HomeYaPackage):
    """
        Build Go binary for Cacher
    """
    type = 'BUILD_PORTAL_CACHER'

    class AutoreleaseParameter(HomeYaPackage.AutoreleaseParameter):
        default_value = 'testing'

    input_parameters = (
        YaPackage.parameters.ArcadiaUrl,
        AutoreleaseParameter,
        StartrekTicketIdsParameter
    )

    def get_context_override(self):
        context = HomeYaPackage.get_context_override(self)
        context[YaPackage.ResourceTypeParameter.name] = PortalCacherTarball.name
        context[HomeYaPackage.HomePackagesParameter.name] = 'portal/avocado/packages/cacher.json'
        return context


__Task__ = BuildPortalCacher
