from sandbox.projects.common.build import YaPackage
from sandbox.projects.home.common.package import HomeYaPackage
from sandbox.projects.home.resources import PortalGreenboxTarball
from sandbox.projects.common.nanny.nanny import StartrekTicketIdsParameter


class BuildPortalGreenbox(HomeYaPackage):
    """
        Build Go binary for Greenbox Apphost servant
    """
    type = 'BUILD_PORTAL_GREENBOX'

    class AutoreleaseParameter(HomeYaPackage.AutoreleaseParameter):
        default_value = 'testing'

    input_parameters = (
        YaPackage.parameters.ArcadiaUrl,
        AutoreleaseParameter,
        StartrekTicketIdsParameter
    )

    def get_context_override(self):
        context = HomeYaPackage.get_context_override(self)
        context[YaPackage.ResourceTypeParameter.name] = PortalGreenboxTarball.name
        context[HomeYaPackage.HomePackagesParameter.name] = 'portal/morda-go/packages/greenbox.json'
        return context


__Task__ = BuildPortalGreenbox
