from sandbox.projects.common.build import YaPackage
from sandbox.projects.home.common.package import HomeYaPackage
from sandbox.projects.home.resources import PortalGreenboxCommonTarball
from sandbox.projects.common.nanny.nanny import StartrekTicketIdsParameter


class BuildPortalGreenboxCommon(HomeYaPackage):
    """
        Build Greenbox utils and config files
    """
    type = 'BUILD_PORTAL_GREENBOX_COMMON'

    class AutoreleaseParameter(HomeYaPackage.AutoreleaseParameter):
        default_value = 'testing'

    input_parameters = (
        YaPackage.parameters.ArcadiaUrl,
        AutoreleaseParameter,
        StartrekTicketIdsParameter
    )

    def get_context_override(self):
        context = HomeYaPackage.get_context_override(self)
        context[YaPackage.ResourceTypeParameter.name] = PortalGreenboxCommonTarball.name
        context[HomeYaPackage.HomePackagesParameter.name] = 'portal/morda-go/packages/greenbox_common.json'
        return context


__Task__ = BuildPortalGreenboxCommon
