from sandbox.projects.common.build import YaPackage
from sandbox.projects.home.common.package import HomeYaPackage
from sandbox.projects.home.resources import PortalMadmTarball
from sandbox.projects.common.nanny.nanny import StartrekTicketIdsParameter


class BuildPortalMadm(HomeYaPackage):
    """
        Build Madm Binary
    """
    type = 'BUILD_PORTAL_MADM'

    class AutoreleaseParameter(HomeYaPackage.AutoreleaseParameter):
        default_value = 'testing'

    input_parameters = (
        YaPackage.parameters.ArcadiaUrl,
        AutoreleaseParameter,
        StartrekTicketIdsParameter
    )

    def get_context_override(self):
        context = HomeYaPackage.get_context_override(self)
        context[YaPackage.ResourceTypeParameter.name] = PortalMadmTarball.name
        context[HomeYaPackage.HomePackagesParameter.name] = 'portal/madm/pkg.json'
        return context


__Task__ = BuildPortalMadm
