from sandbox.projects.common.build import YaPackage
from sandbox.projects.home.common.package import HomeYaPackage
from sandbox.projects.home.resources import PortalMapAddrTarball
from sandbox.projects.common.nanny.nanny import StartrekTicketIdsParameter


class BuildPortalMapAddr(HomeYaPackage):
    """
        Build Go binary for MapAddr Apphost servant
    """
    type = 'BUILD_PORTAL_MAP_ADDR'

    class AutoreleaseParameter(HomeYaPackage.AutoreleaseParameter):
        default_value = 'testing'

    input_parameters = (
        YaPackage.parameters.ArcadiaUrl,
        AutoreleaseParameter,
        StartrekTicketIdsParameter
    )

    def get_context_override(self):
        context = HomeYaPackage.get_context_override(self)
        context[YaPackage.ResourceTypeParameter.name] = PortalMapAddrTarball.name
        context[HomeYaPackage.HomePackagesParameter.name] = 'portal/avocado/map-addr/package.json'
        return context


__Task__ = BuildPortalMapAddr
