from sandbox.projects.common.build import YaPackage
from sandbox.projects.home.common.package import HomeYaPackage
from sandbox.projects.home.resources import PortalMordaCppTarball
from sandbox.projects.common.nanny.nanny import StartrekTicketIdsParameter


class BuildPortalMordaCpp(HomeYaPackage):

    type = 'BUILD_PORTAL_MORDA_CPP'

    class AutoreleaseParameter(HomeYaPackage.AutoreleaseParameter):
        default_value = 'testing'

    input_parameters = (
        YaPackage.parameters.ArcadiaUrl,
        AutoreleaseParameter,
        StartrekTicketIdsParameter
    )

    def get_context_override(self):
        context = HomeYaPackage.get_context_override(self)
        context[YaPackage.ResourceTypeParameter.name] = PortalMordaCppTarball.name
        context[HomeYaPackage.HomePackagesParameter.name] = 'portal/morda/pkg.json'
        return context


__Task__ = BuildPortalMordaCpp
