from sandbox.projects.common.build import YaPackage
from sandbox.projects.home.common.package import HomeYaPackage
from sandbox.projects.home.resources import PortalMordaGoTarball
from sandbox.projects.common.nanny.nanny import StartrekTicketIdsParameter


class BuildPortalMordaGo(HomeYaPackage):
    """
        Build Go binary for Morda helper microservice
    """
    type = 'BUILD_PORTAL_MORDA_GO'

    class AutoreleaseParameter(HomeYaPackage.AutoreleaseParameter):
        default_value = 'testing'

    input_parameters = (
        YaPackage.parameters.ArcadiaUrl,
        AutoreleaseParameter,
        StartrekTicketIdsParameter
    )

    def get_context_override(self):
        context = HomeYaPackage.get_context_override(self)
        context[YaPackage.ResourceTypeParameter.name] = PortalMordaGoTarball.name
        context[HomeYaPackage.HomePackagesParameter.name] = 'portal/morda-go/packages/morda-go.json'
        return context


__Task__ = BuildPortalMordaGo
