from sandbox.projects.common.build import YaPackage
from sandbox.projects.home.common.package import HomeYaPackage
from sandbox.projects.home.resources import PortalWunderwaffeTarball
from sandbox.projects.common.nanny.nanny import StartrekTicketIdsParameter


class BuildPortalWunderwaffe(HomeYaPackage):
    """
        Build Wunderwaffe Binary
    """
    type = 'BUILD_PORTAL_WUNDERWAFFE'

    class AutoreleaseParameter(HomeYaPackage.AutoreleaseParameter):
        default_value = 'testing'

    input_parameters = (
        YaPackage.parameters.ArcadiaUrl,
        AutoreleaseParameter,
        StartrekTicketIdsParameter
    )

    def get_context_override(self):
        context = HomeYaPackage.get_context_override(self)
        context[YaPackage.ResourceTypeParameter.name] = PortalWunderwaffeTarball.name
        context[HomeYaPackage.HomePackagesParameter.name] = 'portal/wunderwaffe/pkg.json'
        return context


__Task__ = BuildPortalWunderwaffe
