from sandbox import sdk2
from partition_cleaner import clean


class PortalRtstatCleaner(sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        debug = sdk2.parameters.String('Debug', default=None)
        clickhouse_host = sdk2.parameters.String('clickhouse host', default='morda-rt-clickhouse.n.yandex-team.ru')
        max_size = sdk2.parameters.Integer('maximum database size (GB)', default=12000)

    def on_execute(self):
        clean(self.Parameters.clickhouse_host, self.Parameters.max_size)

    def on_success(self, prev_status):
        sdk2.Task.on_success(self, prev_status)
