# coding: utf-8

import requests
import logging
import json


MAX_SIZE_GB = 12000
# MAX_SIZE_GB = 10000
CLICKHOUSE_HOST = 'morda-rt-clickhouse.n.yandex-team.ru'
partitions_query = """select partition, table
from system.parts where database='rt' group by partition, table order by partition limit 9"""
total_size_query = """select sum(bytes)/(1024*1024*1024) from system.parts where database='rt'"""
partition_delete_query = """ALTER TABLE rt.{table} DROP PARTITION '{partition}'"""
logger = logging.getLogger()


def make_request(query, clickhouse_host):
    url = 'http://{}/'.format(clickhouse_host)
    query += ' FORMAT JSON'
    result = ''
    try:
        logger.info(query)
        result = requests.post(url, data=query)
        if result.text:
            return json.loads(result.text)['data']
        else:
            logger.error('Empty answer')
            logger.error('status code: {}'.format(result.status_code))
            logger.error('text: {}'.format(result.text))
    except Exception as msg:
        logger.error('Exception: {}'.format(str(msg)))
        logger.error('status code: {}'.format(result.status_code))
        logger.error('text: {}'.format(result.text))
        raise msg


def get_partitions(clickhouse_host):
    # поиск списка партиций и таблиц:
    patitions_result = make_request(partitions_query, clickhouse_host)
    partition_to_clean = patitions_result[0]['partition']
    tables_to_clean = [p['table'] for p in patitions_result if p['partition'] == partition_to_clean]
    return partition_to_clean, tables_to_clean


def clean(clickhouse_host=CLICKHOUSE_HOST, max_size=MAX_SIZE_GB):
    # getting total size
    total_size_result = make_request(total_size_query, clickhouse_host)
    total_size = list(total_size_result[0].values())[0]
    if total_size > max_size:
        partition_to_clean, tables_to_clean = get_partitions(clickhouse_host)
        logger.info('Total size is {:.1f}GB. need to clean partition {} in tables {}'. format(total_size, partition_to_clean, ', '.join(tables_to_clean)))
        for table in tables_to_clean:
            logger.info(partition_delete_query.format(table=table, partition=partition_to_clean))
            make_request(partition_delete_query.format(table=table, partition=partition_to_clean), clickhouse_host)
    else:
        logger.info('Total size is ok: {:.1f} GB'. format(total_size))
