from sandbox import sdk2
from sandbox.sdk2 import yav

import params
import razladki_pusher


class PortalRazladkiPusher(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        debug = sdk2.parameters.String('Debug', default=None)
        evbogdanov_solomon_oauth_token = ''
        clickhouse_host = sdk2.parameters.String('clickhouse host', default='morda-rt-clickhouse.n.yandex-team.ru')
        with sdk2.parameters.Group("Request parameters") as parameters:
            block_clicks = sdk2.parameters.List("Block clicks", default=params.block_clicks)
            access_browser_names = sdk2.parameters.List("Browser names for access", default=params.access_browser_names)
            geoids = sdk2.parameters.List("Access geoids", default=params.geoids)
            content_types = sdk2.parameters.List("Content types", default=params.content_types)
            m_zones = sdk2.parameters.List("m_zone list", default=params.m_zones)
            show_blocks = sdk2.parameters.List("Block shows", default=params.show_blocks)
            additional_queries = sdk2.parameters.String('Additional queries', default='', multiline=True)

    def on_execute(self):
        secret = yav.Secret("sec-01dvpbhaj6bfwxzecy94s0kztn", "ver-01dvpbhak540r1n09qwmh1b9bm")
        db_pass = secret.data()["clickhouse_production_morda"]
        razladki_pusher.make_requests_with_params(self.Parameters, sdk2.Vault.data('evbogdanov_solomon_oauth_token'), db_pass)

    def on_success(self, prev_status):
        sdk2.Task.on_success(self, prev_status)
