# coding: utf-8


content_types = [
    '',
    'yaru',
    'big',
    'touch',
    'intercept404',
    'chromenewtab',
    'hw',
    'api_data_big',
    'tv',
    'mob',
    'comtr',
    'com',
    'yabrotab',
]

geoids = [
    0,
    213, 2, 65,
    54, 47, 51,
    35, 76, 39,
    162, 64, 172,
    157, 62, 43,
    75, 56, 10318,
    63, 66,
]

m_zones = [
    "ru",
    "",
    "kz",
    "by",
    "ua",
    "com.tr",
    "com",
    "fr",
    "uz",
]

block_clicks = [
    'total',
    'v14',
    'v14.news',
    'v14.infinity_zen',
    'v14.notifications',
    'v14.weather',
    'v14.tabs',
    'v14.dist',
    'v14.keyboard',
    'v14.head',
    'v14.news_rates_manual',
    'v14.foot',
    'v14.mail',
    'v14.voice',
    'v14.logo',
    'v14.maps',
    'v14.traffic',
    'v14.kinopoisk',
    'v14.mediafooter',
    'v14.tabsPopup',
    'v14.afisha_inserts',
    'v14.business',
    'v14.restoreMobileBalloon',
    'v14_androidpad',
    'v14_androidpad.infinity_zen',
    'v14_androidpad.news',
    'v14_ipad',
    'v14_ipad.infinity_zen',
    'v14_ipad.news',
    'v14.services_new.item',
    'v14.services_new.popup',
    'v14.services_new.more',
    'v14.div_news_inserts',
    'v14.rtb_inserts.content',
    'yandexcom',
    'spok',
    'spok.infinity_zen',
    'streamhandler',
    'streamhandler.big',
    'comtr',
    'all',
    'tv',
    'touchtr',
    'verticals',
    'wwwyaru',
    'efir',
    'videohub',
    'videohub_touch',
    'chromenewtab',
    'chromenewtab.bookmarks',
    'chromenewtab.infinity_zen',
    'chromenewtab.logo',
    'chromenewtab_worker',
    'chromenewtab_worker.infinity_zen',
    'chromenewtab_worker.logo',
    'geotouch',
    'geotouch.news',
    'geotouch.search_input',
    'geotouch.zen',
    'geotouch.informer',
    'geotouch.suggest_example',
    'geotouch.covid_gallery',
    'geotouch.infinity_zen',
    'geotouch.div_personal_news',
    'geotouch.directfeed.content',
    'geotouch.directfeed_2.content',
    'yabrotab_client.scroll_to_tab',
    'yabrotab_client.news',
    'yabrotab_client.weather',
    'yabrotab_client.notifications',
    'yabrotab_client.channels',
    'yabrotab_client.morda_enabled_by_user',
    'yabrotab_client.traffic',
    'mordalib_client.scroll_to_tab',
    'mordalib_client.news',
    'mordalib_client.weather',
    'mordalib_client.notifications',
    'mordalib_client.channels',
    'mordalib_client.traffic',
]

access_browser_names = [
    '',
    'YandexBrowser',
    'Chrome',
    'Unknown',
    'YandexSearch',
    'Firefox',
    'MSIE',
    'Opera',
    'Samsung Internet',
    'ChromeMobile',
    'MobileSafari',
    'Dalvik',
    'Edge',
    'AndroidBrowser',
    'Safari',
    'MIUI',
    'IEMobile',
    'OperaMini',
    'OperaMobile',
    'Chromium',
    'UCBrowser'
]

show_blocks = [
    'v14.news',
    'geotouch',
    'chromenewtab_worker',
    'v14_ipad'
]

PARAMS = {
    'access': {
        'query': """
SELECT
    toUnixTimestamp(time) as unixtime,
    count(1) as value
FROM rum.morda_access
WHERE date = {date}
    and timestamp > toUnixTimestamp(toStartOfFiveMinute(toDateTime({from_time})))
    and timestamp < toUnixTimestamp(toStartOfFiveMinute(toDateTime({to_time})))
group by toStartOfFiveMinute(toDateTime(timestamp)) as time
order by time desc
"""
    },
}

PARAMS_COMPLEX = {
    "access_by_browser": {
        'sensor': 'access',
        'by': 'browser',
        'complex': True,
        'query': """
SELECT
    ua.browsername as mod,
    toUnixTimestamp(time) as unixtime,
    count(1) as value
FROM rum.morda_access
WHERE date = {{date}}
    and timestamp > toUnixTimestamp(toStartOfFiveMinute(toDateTime({{from_time}})))
    and timestamp < toUnixTimestamp(toStartOfFiveMinute(toDateTime({{to_time}})))
    and has([{browser_names}], CAST(mod, 'String'))
group by ua.browsername, toStartOfFiveMinute(toDateTime(timestamp)) as time
order by time desc
"""
    },
    "access_by_geo": {
        'sensor': 'access',
        'by': 'geo',
        'complex': True,
        'query': """
select
    toUnixTimestamp(time) as unixtime,
    geo_h_region as mod,
    count(1) as value
from rum.morda_access
where date = {{date}}
    and timestamp > toUnixTimestamp(toStartOfFiveMinute(toDateTime({{from_time}})))
    and timestamp < toUnixTimestamp(toStartOfFiveMinute(toDateTime({{to_time}})))
    and has([{geoids}], mod)
group by toStartOfFiveMinute(toDateTime(timestamp)) as time, mod
order by time desc
"""
    },
    "access_by_content": {
        'sensor': 'access',
        'by': 'content',
        'complex': True,
        'query': """
SELECT
    m_content as mod,
    toUnixTimestamp(time) as unixtime,
    count(1) as value
FROM rum.morda_access
WHERE date = {{date}}
    and timestamp > toUnixTimestamp(toStartOfFiveMinute(toDateTime({{from_time}})))
    and timestamp < toUnixTimestamp(toStartOfFiveMinute(toDateTime({{to_time}})))
    and has([{content}], CAST(mod, 'String'))
group by m_content, toStartOfFiveMinute(toDateTime(timestamp)) as time
order by time desc
"""
    },
    "access_by_mzone": {
        'sensor': 'access',
        'by': 'mzone',
        'complex': True,
        'query': """
SELECT
    m_zone as mod,
    toUnixTimestamp(time) as unixtime,
    count(1) as value
FROM rum.morda_access
WHERE date = {{date}}
    and timestamp > toUnixTimestamp(toStartOfFiveMinute(toDateTime({{from_time}})))
    and timestamp < toUnixTimestamp(toStartOfFiveMinute(toDateTime({{to_time}})))
    and has([{mzones}], CAST(mod, 'String'))
group by m_zone, toStartOfFiveMinute(toDateTime(timestamp)) as time
order by time desc
"""
    },
    "shows": {
        'sensor': 'shows',
        'query': """
            select
                toUnixTimestamp(time) as unixtime,
                count(1) as value
            from rum.morda_blockdisplay
            where date = {{date}}
                and timestamp > toUnixTimestamp(toStartOfFiveMinute(toDateTime({{from_time}})))
                and timestamp < toUnixTimestamp(toStartOfFiveMinute(toDateTime({{to_time}})))
                and has(blocks, '{block_name}')
            group by toStartOfFiveMinute(toDateTime(timestamp)) as time
            order by time desc
            """
    }
}

PARAMS_COMPLEX_OLD = {
    'access_by_browser_{}': {
        'complex': True,
        'query': """
SELECT
    ua.browsername as mod,
    toUnixTimestamp(time) as unixtime,
    count(1) as value
FROM rum.morda_access
WHERE date = {{date}}
    and timestamp > toUnixTimestamp(toStartOfFiveMinute(toDateTime({{from_time}})))
    and timestamp < toUnixTimestamp(toStartOfFiveMinute(toDateTime({{to_time}})))
    and has([{browser_names}], CAST(mod, 'String'))
group by ua.browsername, toStartOfFiveMinute(toDateTime(timestamp)) as time
order by time desc
"""
    },
    'access_by_geo_{}': {
        'complex': True,
        'query': """
select
    toUnixTimestamp(time) as unixtime,
    geo_h_region as mod,
    count(1) as value
from rum.morda_access
where date = {{date}}
    and timestamp > toUnixTimestamp(toStartOfFiveMinute(toDateTime({{from_time}})))
    and timestamp < toUnixTimestamp(toStartOfFiveMinute(toDateTime({{to_time}})))
    and has([{geoids}], CAST(mod, 'String'))
group by toStartOfFiveMinute(toDateTime(timestamp)) as time, mod
order by time desc
"""
    },
    'access_by_content_{}': {
        'complex': True,
        'query': """
SELECT
    m_content as mod,
    toUnixTimestamp(time) as unixtime,
    count(1) as value
FROM rum.morda_access
WHERE date = {{date}}
    and timestamp > toUnixTimestamp(toStartOfFiveMinute(toDateTime({{from_time}})))
    and timestamp < toUnixTimestamp(toStartOfFiveMinute(toDateTime({{to_time}})))
    and has([{content}], CAST(mod, 'String'))
group by m_content, toStartOfFiveMinute(toDateTime(timestamp)) as time
order by time desc
"""
    },
    'access_by_mzone_{}': {
        'complex': True,
        'query': """
SELECT
    m_zone as mod,
    toUnixTimestamp(time) as unixtime,
    count(1) as value
FROM rum.morda_access
WHERE date = {{date}}
    and timestamp > toUnixTimestamp(toStartOfFiveMinute(toDateTime({{from_time}})))
    and timestamp < toUnixTimestamp(toStartOfFiveMinute(toDateTime({{to_time}})))
    and has([{mzones}], CAST(mod, 'String'))
group by m_zone, toStartOfFiveMinute(toDateTime(timestamp)) as time
order by time desc
"""
    },
    'shows_{}': {
        'query': """
            select
                toUnixTimestamp(time) as unixtime,
                count(1) as value
            from rum.morda_blockdisplay
            where date = {{date}}
                and timestamp > toUnixTimestamp(toStartOfFiveMinute(toDateTime({{from_time}})))
                and timestamp < toUnixTimestamp(toStartOfFiveMinute(toDateTime({{to_time}})))
                and has(CAST(blocks, 'String'), '{block_name}')
            group by toStartOfFiveMinute(toDateTime(timestamp)) as time
            order by time desc
            """
    }
}

CLICKS_PARAM = {
    'query': """
select
    extract(path, '([\\\\w\\\\d-_]+(\\\\.[\\\\w\\\\d-_]+)?(\\\\.[\\\\w\\\\d-_]+)?)') as path,
    toUnixTimestamp(time) as unixtime,
    count(1) as clicks
from rum.morda_redir
where date = {date}
    and event_type = 'click'
    and timestamp > toUnixTimestamp(toStartOfFiveMinute(toDateTime({from_time})))
    and timestamp < toUnixTimestamp(toStartOfFiveMinute(toDateTime({to_time})))
group by path, toStartOfFiveMinute(toDateTime(timestamp)) as time
order by time desc
"""
}
