import logging
import os

from sandbox import sdk2
import sandbox.sandboxsdk.environments as env
from sandbox.sandboxsdk import process

# SMOOTHIE_PUSHES_REPORT_VERAL


class SmoothiePushesReportVeral(sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        did = sdk2.parameters.String('Did', default=None)
        debug = sdk2.parameters.String('Debug', default=None)

    def on_execute(self):
        logging.info('Did' + self.Parameters.did)
        with env.VirtualEnvironment() as venv:
            logging.info('Installing yql')
            env.PipEnvironment('yql', version="1.2.49", venv=venv).prepare()
            logging.info('Done')

            yt_token = sdk2.Vault.data(self.owner, "pushes-report-veral-yt-token")
            logging.info('Token got')

            cmd = [
                venv.executable, os.path.dirname(__file__) + '/script.py',
                "--did", self.Parameters.did,
                # robot-morda-push-sup
                "--yt_token", yt_token,
            ]
            if self.Parameters.debug:
                cmd.append("--debug")
            process.run_process(cmd, log_prefix='script')
