from __future__ import print_function
import logging
import sys
import argparse
from datetime import datetime as dt, timedelta

from yql.api.v1.client import YqlClient

DEFAULT_DID = '0a9de8033bc2f2ddf2eb4e7dfa62b7de'  # veral did
TABLE = '//home/morda/smoothie/{}/veral_pushes'


def run(did, token):
    date = get_yesterday_date()
    logging.info('date={}'.format(date))
    make_report(date=date, did=did, token=token)


def make_report(date, did, token):
    client = YqlClient(
            db='hahn',
            # robot-morda-push-sup
            token=token
    )
    query = """
            SELECT
                appId,
                appVersion,
                iid,
                iso_eventtime,
                pid,
                regionId,
                state
            FROM
                [home/logfeller/logs/push-chunks-log/1d/{}]
            WHERE
                did='{}'
            ORDER BY iso_eventtime
            ;
            """.format(
            date,
            str(did))

    request = client.query(query)
    request.run()

    data = []
    for table in request.get_results():  # access to results blocks until they are ready
        table.fetch_full_data()  # see https://nda.ya.ru/3S3j25

        for row in table.rows:
            data.append(row)
    names = [
        'appId',
        'appVersion',
        'iid',
        'iso_eventtime',
        'pid',
        'regionId',
        'state'
    ]
    types = [
        'String?',
        'String?',
        'String?',
        'String?',
        'String?',
        'String?',
        'String?',
    ]
    client.write_table(TABLE.format(date), data, names, types, external_tx='new')


def get_yesterday_date():
    yesterday = dt.now() - timedelta(days=1)
    return yesterday.strftime('%Y-%m-%d')


def set_logger(debug):
    logger = logging.getLogger()
    if debug:
        logger.setLevel(logging.DEBUG)
    else:
        logger.setLevel(logging.INFO)

    logger.handlers = [logging.StreamHandler(sys.stderr)]


if __name__ == '__main__':
    arg_parser = argparse.ArgumentParser(description='Report about pushed for certain did')
    arg_parser.add_argument('--did', action='store', help='did')
    arg_parser.add_argument('--yt_token', action='store', help='yt_token')
    arg_parser.add_argument('--debug', '-d', action='store_true', help='Add debug messages to log.')
    args = arg_parser.parse_args()

    assert args.yt_token

    set_logger(debug=args.debug)

    logging.info('args of cli: {}'.format(args))

    did = args.did if args.did else DEFAULT_DID
    logging.info('Did={}'.format(did))

    run(did, args.yt_token)
