# -*- coding: utf-8 -*-
import tarfile

import sandbox.projects.common.arcadia.sdk as arcadia_sdk
import sandbox.projects.common.requests_wrapper as req_w
from sandbox.projects.common import task_env
import sandbox.projects.horadric.resources as horadric_resources
from sandbox import sdk2


class ReleaseHoradricUi(sdk2.Task):
    """ For releases using zcli """
    class Requirements(task_env.TinyRequirements):
        disk_space = 1 * 1024  # 1 Gb

    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 15 * 60  # 15 min

        resource = sdk2.parameters.Resource("Resource to release", resource_type=horadric_resources.HoradricUI)
        version = sdk2.parameters.String("Version")
        dest_folder = sdk2.parameters.String("Destination folder", default_value="dist")
        access_secret_key = sdk2.parameters.String("Access secret key (SB Vault)", required=True)

    def on_execute(self):
        super(ReleaseHoradricUi, self).on_execute()
        access_key = sdk2.Vault.data(self.Parameters.access_secret_key)
        with tarfile.open(str(sdk2.ResourceData(self.Parameters.resource).path), "r") as tar:
            tar.extractall()
        with arcadia_sdk.mount_arc_path("arcadia-arc:/#trunk", use_arc_instead_of_aapi=True) as arcadia_dir:
            with sdk2.helpers.ProcessLog(self, logger="upload_ui_to_zephyr") as pl:
                sdk2.helpers.subprocess.check_call(
                    [
                        "{}ya".format(arcadia_dir), "tool", "zcli",
                        self.Parameters.dest_folder,
                        "--access-key", access_key,
                        "-v", self.Parameters.version,
                        "--set-as-current",
                    ],
                    stdout=pl.stdout, stderr=pl.stderr
                )
        req_w.post_r(
            "https://z.yandex-team.ru/api/zephyr.Storage/setStaticBundle",
            json={
                "access_key": access_key,
                "version": self.Parameters.version
            }
        )
