# -*- coding: utf-8 -*-
from sandbox import sdk2
from sandbox.projects.common.build.tasks import YaMakeTemplate
from sandbox.projects.resource_types import search_priemka_releasers


class CFGPullerModelBinary(sdk2.Resource):
    """
    CFGPuller model binary.
    """
    releasable = True
    any_arch = False
    releasers = search_priemka_releasers + ["robot-testenv"]
    auto_backup = True
    arcadia_build_path = 'apphost/tools/transport/config_puller/config_puller'


class BuildCfgPuller(YaMakeTemplate.YaMakeTemplate):
    """
    Build CFGPuller model binary.
    """
    class Parameters(YaMakeTemplate.get_project_params([CFGPullerModelBinary])):
        pass
