# -*- coding:utf-8 -*-
import logging
import yaml
import re

import sandbox.projects.common.build.parameters as params
import sandbox.projects.common.nanny.nanny as nanny
from sandbox import sdk2
from sandbox.projects.horizon.resources import news_graphs_resources
from sandbox.projects.horizon.resources import vkus_graphs_resources
from sandbox.projects.horizon.resources import health_graphs_resources
from sandbox.projects.horizon.resources import zen_graphs_resources
from sandbox.projects.horizon.resources import morda_graphs_resources
from sandbox.projects.horizon.resources import geo_graphs_resources
from sandbox.projects.horizon.resources import ugc_graphs_resources
from sandbox.projects.horizon.resources import antiadbtest_graphs_resources
from sandbox.projects.horizon.resources import example_graphs_resources
from sandbox.projects.horizon.resources import fei_graphs_resources
from sandbox.projects.horizon.resources import caesar_graphs_resources
from sandbox.projects.horizon.resources import jobs_graphs_resources
from sandbox.projects.horizon.resources import faas_graphs_resources
from sandbox.projects.horizon.resources import kinopoisk_graphs_resources
from sandbox.projects.horizon.resources import lpc_graphs_resources
from sandbox.projects.horizon.resources import market_graphs_resources
from sandbox.projects.horizon.resources import newtestt_graphs_resources
from sandbox.projects.horizon.resources import testing_vertical_graphs_resources
from sandbox.projects.horizon.resources import newspartner_graphs_resources
from sandbox.projects.horizon.resources import hiworld_graphs_resources
from sandbox.projects.horizon.resources import lego_graphs_resources
from sandbox.projects.horizon.resources import goods_graphs_resources
from sandbox.projects.horizon.resources import newsrobot_graphs_resources
from sandbox.projects.horizon.resources import myvert_graphs_resources
from sandbox.projects.horizon.resources import rrload_graphs_resources
from sandbox.projects.horizon.resources import booktaas_graphs_resources
from sandbox.projects.horizon.resources import forms_graphs_resources
from sandbox.projects.horizon.resources import garage_graphs_resources
from sandbox.projects.horizon.resources import ydo_graphs_resources
from sandbox.projects.horizon.resources import schoolbook_graphs_resources
from sandbox.projects.horizon.resources import report_graphs_resources
from sandbox.projects.horizon.resources import marketreport_graphs_resources
from sandbox.projects.horizon.resources import smartcamerafront_graphs_resources
from sandbox.projects.horizon.resources import laas_graphs_resources
from sandbox.projects.horizon.resources import crm_graphs_resources
from sandbox.projects.horizon.resources import stateful_graphs_resources
from sandbox.projects.horizon.resources import begemot_graphs_resources
from sandbox.projects.horizon.resources import sport_graphs_resources
from sandbox.projects.horizon.resources import sportnewsrobot_graphs_resources
from sandbox.projects.horizon.resources import alicerpc_graphs_resources
from sandbox.projects.horizon import resources
from sandbox.sdk2.vcs.svn import Arcadia


vertical_resource_map = {
    'ALICERPC': (alicerpc_graphs_resources.HorizonAgentConfigAlicerpc, alicerpc_graphs_resources.AppHostStableBranchAlicerpc),
    'SPORTNEWSROBOT': (sportnewsrobot_graphs_resources.HorizonAgentConfigSportnewsrobot, sportnewsrobot_graphs_resources.AppHostStableBranchSportnewsrobot),
    'SPORT': (sport_graphs_resources.HorizonAgentConfigSport, sport_graphs_resources.AppHostStableBranchSport),
    'BEGEMOT': (begemot_graphs_resources.HorizonAgentConfigBegemot, begemot_graphs_resources.AppHostStableBranchBegemot),
    'STATEFUL': (stateful_graphs_resources.HorizonAgentConfigStateful, stateful_graphs_resources.AppHostStableBranchStateful),
    'CRM': (crm_graphs_resources.HorizonAgentConfigCrm, crm_graphs_resources.AppHostStableBranchCrm),
    'LAAS': (laas_graphs_resources.HorizonAgentConfigLaas, laas_graphs_resources.AppHostStableBranchLaas),
    'SMARTCAMERAFRONT': (smartcamerafront_graphs_resources.HorizonAgentConfigSmartcamerafront, smartcamerafront_graphs_resources.AppHostStableBranchSmartcamerafront),
    'MARKETREPORT': (marketreport_graphs_resources.HorizonAgentConfigMarketreport, marketreport_graphs_resources.AppHostStableBranchMarketreport),
    'REPORT': (report_graphs_resources.HorizonAgentConfigReport, report_graphs_resources.AppHostStableBranchReport),
    'SCHOOLBOOK': (schoolbook_graphs_resources.HorizonAgentConfigSchoolbook, schoolbook_graphs_resources.AppHostStableBranchSchoolbook),
    'YDO': (ydo_graphs_resources.HorizonAgentConfigYdo, ydo_graphs_resources.AppHostStableBranchYdo),
    'GARAGE': (garage_graphs_resources.HorizonAgentConfigGarage, garage_graphs_resources.AppHostStableBranchGarage),
    'FORMS': (forms_graphs_resources.HorizonAgentConfigForms, forms_graphs_resources.AppHostStableBranchForms),
    'BOOKTAAS': (booktaas_graphs_resources.HorizonAgentConfigBooktaas, booktaas_graphs_resources.AppHostStableBranchBooktaas),
    'RRLOAD': (rrload_graphs_resources.HorizonAgentConfigRrload, rrload_graphs_resources.AppHostStableBranchRrload),
    'MYVERT': (myvert_graphs_resources.HorizonAgentConfigMyvert, myvert_graphs_resources.AppHostStableBranchMyvert),
    'NEWSROBOT': (newsrobot_graphs_resources.HorizonAgentConfigNewsrobot, newsrobot_graphs_resources.AppHostStableBranchNewsrobot),
    'GOODS': (goods_graphs_resources.HorizonAgentConfigGoods, goods_graphs_resources.AppHostStableBranchGoods),
    'LEGO': (lego_graphs_resources.HorizonAgentConfigLego, lego_graphs_resources.AppHostStableBranchLego),
    'HIWORLD': (hiworld_graphs_resources.HorizonAgentConfigHiworld, hiworld_graphs_resources.AppHostStableBranchHiworld),
    'NEWSPARTNER': (newspartner_graphs_resources.HorizonAgentConfigNewspartner, newspartner_graphs_resources.AppHostStableBranchNewspartner),
    'TEST': (testing_vertical_graphs_resources.HorizonAgentConfigTest, testing_vertical_graphs_resources.AppHostStableBranchTest),
    'NEWTESTT': (newtestt_graphs_resources.HorizonAgentConfigNewtestt, newtestt_graphs_resources.AppHostStableBranchNewtestt),
    'MARKET': (market_graphs_resources.HorizonAgentConfigMarket, market_graphs_resources.AppHostStableBranchMarket),
    'LPC': (lpc_graphs_resources.HorizonAgentConfigLpc, lpc_graphs_resources.AppHostStableBranchLpc),
    'KINOPOISK': (kinopoisk_graphs_resources.HorizonAgentConfigKinopoisk, kinopoisk_graphs_resources.AppHostStableBranchKinopoisk),
    'FAAS': (faas_graphs_resources.HorizonAgentConfigFaas, faas_graphs_resources.AppHostStableBranchFaas),
    'JOBS': (jobs_graphs_resources.HorizonAgentConfigJobs, jobs_graphs_resources.AppHostStableBranchJobs),
    'CAESAR': (caesar_graphs_resources.HorizonAgentConfigCaesar, caesar_graphs_resources.AppHostStableBranchCaesar),
    'FEI': (fei_graphs_resources.HorizonAgentConfigFei, fei_graphs_resources.AppHostStableBranchFei),
    'EXAMPLE': (example_graphs_resources.HorizonAgentConfigExample, example_graphs_resources.AppHostStableBranchExample),
    'ANTIADBTEST': (antiadbtest_graphs_resources.HorizonAgentConfigAntiadbtest, antiadbtest_graphs_resources.AppHostStableBranchAntiadbtest),
    'UGC': (ugc_graphs_resources.HorizonAgentConfigUgc, ugc_graphs_resources.AppHostStableBranchUgc),
    'GEO': (geo_graphs_resources.HorizonAgentConfigGeo, geo_graphs_resources.AppHostStableBranchGeo),
    'HEALTH': (health_graphs_resources.HorizonAgentConfigHealth, health_graphs_resources.AppHostStableBranchHealth),
    'VKUS': (vkus_graphs_resources.HorizonAgentConfigVkus, vkus_graphs_resources.AppHostStableBranchVkus),
    'NEWS': (news_graphs_resources.HorizonAgentConfigNews, news_graphs_resources.AppHostStableBranchNews),
    'ALICE': (resources.HorizonAgentConfigAlice, resources.AppHostStableBranchAlice),
    'COMMON': (resources.HorizonAgentConfigCommon, resources.AppHostStableBranchCommon),
    'DISTRICT': (resources.HorizonAgentConfigDistrict, resources.AppHostStableBranchDistrict),
    'MUSIC': (resources.HorizonAgentConfigMusic, resources.AppHostStableBranchMusic),
    'IMGS': (resources.HorizonAgentConfigImages, resources.AppHostStableBranchImages),
    'MAIL': (resources.HorizonAgentConfigMail, resources.AppHostStableBranchMail),
    'MAILCORP': (resources.HorizonAgentConfigMailcorp, resources.AppHostStableBranchMailcorp),
    'SHARED': (resources.HorizonAgentConfigShared, resources.AppHostStableBranchShared),
    'VIDEO': (resources.HorizonAgentConfigVideo, resources.AppHostStableBranchVideo),
    'VIDEO_HOSTING': (resources.HorizonAgentConfigVideoHosting, resources.AppHostStableBranchVideoHosting),
    'VOICE': (resources.HorizonAgentConfigVoice, resources.AppHostStableBranchVoice),
    'WEATHER': (resources.HorizonAgentConfigWeather, resources.AppHostStableBranchWeather),
    'WEB': (resources.HorizonAgentConfigWeb, resources.AppHostStableBranchWeb),
    'YABS': (resources.HorizonAgentConfigYabs, resources.AppHostStableBranchYabs),
    'ZEN': (zen_graphs_resources.HorizonAgentConfigZen, zen_graphs_resources.AppHostStableBranchZen),
    'PCODE': (resources.HorizonAgentConfigPcode, resources.AppHostStableBranchPcode),
    'MORDA': (morda_graphs_resources.HorizonAgentConfigMorda, morda_graphs_resources.AppHostStableBranchMorda),
}

TAG_RE = re.compile(r".*(tags/releases/apphost/conf/[a-zA-Z]+/stable-[\d]+-[\d]+).*")


class BuildHorizonAgentConfig(sdk2.Task, nanny.ReleaseToNannyTask2):

    class Parameters(sdk2.Task.Parameters):
        vertical = sdk2.parameters.String("Vertical", required=True)
        checkout_arcadia_from_url = params.ArcadiaUrl()
        arc_tag = sdk2.parameters.String("arc tag")


    @staticmethod
    def get_stable_branch_from_arc_path(arc_path):
        return str(arc_path.lstrip('arc/').rstrip('/arcadia').replace('/', '_'))

    def on_execute(self):

        horizon_agent_conf_file = "horizon_agent.yaml"
        stable_branch_file = "stable_branch"

        stable_branch_name = ""
        if self.Parameters.arc_tag:
            tag_match = TAG_RE.match(self.Parameters.arc_tag)
            if tag_match and tag_match.group(1):
                stable_branch_name = self.get_stable_branch_from_arc_path(tag_match.group(1))

            if not stable_branch_name:
                raise ValueError("Invalid arc tag specified: %s".format(self.Parameters.arc_tag))

        elif self.Parameters.checkout_arcadia_from_url:
            arcadia_url = Arcadia.parse_url(self.Parameters.checkout_arcadia_from_url)
            stable_branch_name = self.get_stable_branch_from_arc_path(arcadia_url.path)
            logging.info("ARC path: %s", arcadia_url.path)

            if not stable_branch_name:
                raise ValueError("Invalid arcadia_url specified: %s".format(self.Parameters.checkout_arcadia_from_url))

        agent_config_cls, stable_branch_res_cls = vertical_resource_map.get(
            str(self.Parameters.vertical), (resources.HorizonAgentConfig, resources.AppHostStableBranch)
        )
        resource = agent_config_cls(self, "Horizon agent configuration file", horizon_agent_conf_file)
        resource_data = sdk2.ResourceData(resource)
        with open(str(resource_data.path), "w") as fd:
            config_content = {
                    "vertical": str(self.Parameters.vertical),
                }

            yaml.dump(config_content, fd, default_flow_style=False)
        resource_data.ready()

        stable_branch_res_data = sdk2.ResourceData(stable_branch_res_cls(self, "Stable branch for AppHost and Horizon Agent", stable_branch_file))
        with open(str(stable_branch_res_data.path), "w") as fd:
            fd.write(stable_branch_name)
        stable_branch_res_data.ready()

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask2.on_release(self, additional_parameters)
        sdk2.Task.on_release(self, additional_parameters)
