# -*- coding:utf-8 -*-
from sandbox import sdk2
from sandbox.projects import resource_types as rt


class HorizonAgentConfig(sdk2.Resource):
    """
    Horizon agent config.
    """
    releasable = True
    any_arch = False
    releasers = rt.apphost_config_bundle_releasers
    auto_backup = True


class HorizonAgentConfigAlice(HorizonAgentConfig):
    releasers = HorizonAgentConfig.releasers + rt.assistant_apphost_releasers


class HorizonAgentConfigCommon(HorizonAgentConfig):
    releasers = HorizonAgentConfig.releasers + rt.common_releasers


class HorizonAgentConfigDistrict(HorizonAgentConfig):
    releasers = HorizonAgentConfig.releasers + ['DISTRICT']


class HorizonAgentConfigMusic(HorizonAgentConfig):
    releasers = HorizonAgentConfig.releasers + rt.releasers.music_search_releasers


class HorizonAgentConfigMail(HorizonAgentConfig):
    pass


class HorizonAgentConfigMailcorp(HorizonAgentConfig):
    pass


class HorizonAgentConfigWeb(HorizonAgentConfig):
    pass


class HorizonAgentConfigImages(HorizonAgentConfig):
    pass


class HorizonAgentConfigVideo(HorizonAgentConfig):
    releasers = rt.apphost_config_bundle_video_releasers


class HorizonAgentConfigShared(HorizonAgentConfig):
    pass


class HorizonAgentConfigVideoHosting(HorizonAgentConfig):
    releasers = HorizonAgentConfig.releasers + ['VH']


class HorizonAgentConfigVoice(HorizonAgentConfig):
    releasers = HorizonAgentConfig.releasers + ['VOICE_APPHOST_RELEASERS']


class HorizonAgentConfigWeather(HorizonAgentConfig):
    releasers = HorizonAgentConfig.releasers + ['WEATHER']


class HorizonAgentConfigYabs(HorizonAgentConfig):
    pass


class HorizonAgentConfigPcode(HorizonAgentConfig):
    releasers = HorizonAgentConfig.releasers + ['PCODE']


class AppHostStableBranch(sdk2.Resource):
    releasable = True
    any_arch = False
    releasers = rt.apphost_config_bundle_releasers
    auto_backup = True


class AppHostStableBranchAlice(AppHostStableBranch):
    releasers = AppHostStableBranch.releasers + rt.assistant_apphost_releasers


class AppHostStableBranchCommon(AppHostStableBranch):
    releasers = AppHostStableBranch.releasers + rt.common_releasers


class AppHostStableBranchDistrict(AppHostStableBranch):
    releasers = AppHostStableBranch.releasers + ['DISTRICT']


class AppHostStableBranchMusic(AppHostStableBranch):
    releasers = AppHostStableBranch.releasers + rt.releasers.music_search_releasers


class AppHostStableBranchImages(AppHostStableBranch):
    pass


class AppHostStableBranchMail(AppHostStableBranch):
    pass


class AppHostStableBranchMailcorp(AppHostStableBranch):
    pass


class AppHostStableBranchWeb(AppHostStableBranch):
    pass


class AppHostStableBranchVideo(AppHostStableBranch):
    releasers = rt.apphost_config_bundle_video_releasers


class AppHostStableBranchVoice(AppHostStableBranch):
    releasers = AppHostStableBranch.releasers + ['VOICE_APPHOST_RELEASERS']


class AppHostStableBranchShared(AppHostStableBranch):
    pass


class AppHostStableBranchVideoHosting(AppHostStableBranch):
    releasers = AppHostStableBranch.releasers + ['VH']


class AppHostStableBranchWeather(AppHostStableBranch):
    releasers = AppHostStableBranch.releasers + ['WEATHER']


class AppHostStableBranchYabs(AppHostStableBranch):
    pass


class AppHostStableBranchPcode(AppHostStableBranch):
    releasers = AppHostStableBranch.releasers + ['PCODE']
