# -*- coding:utf-8 -*-
from sandbox import sdk2
from sandbox.projects.resource_types import apphost_releasers, search_priemka_releasers


class HorizonModelBinary(sdk2.Resource):
    """
    Horizon model binary.
    """
    releasable = True
    any_arch = False
    releasers = apphost_releasers + search_priemka_releasers
    auto_backup = True
    arcadia_build_path = 'apphost/daemons/horizon/bin/horizon'


class HorizonDiscoveryBinary(sdk2.Resource):
    """
    Horizon Discovery binary
    """
    releasable = True
    any_arch = False
    releasers = apphost_releasers + search_priemka_releasers
    auto_backup = True
    arcadia_build_path = 'apphost/daemons/horizon/bin/discovery/discovery'


class HorizonAgentBinary(sdk2.Resource):
    """
    Horizon agent binary.
    """
    releasable = True
    any_arch = False
    releasers = apphost_releasers + search_priemka_releasers
    auto_backup = True
    arcadia_build_path = 'apphost/daemons/horizon/agent/horizon-agent'


class HorizonNoraAgentBinary(sdk2.Resource):
    """
    Horizon Nora agent binary.
    Should be removed as "Nora" was temporary naming. Remove it carefully after making sure that it is not used anywhere.
    """
    releasable = True
    any_arch = False
    releasers = apphost_releasers + search_priemka_releasers
    auto_backup = True
    arcadia_build_path = 'apphost/daemons/horizon/agent/horizon-agent'


class ArcspotterBinary(sdk2.Resource):
    """
    Horizon arc spotter binary.
    """
    releaseable = True
    any_arch = False
    releasers = apphost_releasers + search_priemka_releasers
    auto_backup = True
    arcadia_build_path = 'apphost/horizon/arcspotter/bin/arcspotter'
