import logging
import sandbox.common
from sandbox.projects.release_machine.components import all as rmc
from sandbox.projects.release_machine.helpers.startrek_helper import STHelper


def post_comment(token, comment_text, ticket_target):
    logging.info('Post to ticket: %s', comment_text)
    if not ticket_target:
        return
    st = sandbox.common.rest.Client(
        base_url='https://st-api.yandex-team.ru/v2',
        auth=token
    )
    st.issues[ticket_target].comments.create(text=comment_text)


def find_ticket_by_branch(token, branch_number_for_tag):
    if branch_number_for_tag :
        c_info = rmc.COMPONENTS['images_semidups']()
        st_helper = STHelper(token)
        ticket = st_helper.find_ticket_by_release_number(branch_number_for_tag, c_info, fail=False)
        if ticket:
            return ticket.id
    return None


def log_task_begin_in_ticket(token, ticket_id, task):
    ticket_message = "Launching sandbox task ({}): http://sandbox.yandex-team.ru/sandbox/tasks/view?task_id={}\n".format(task.type, task.id)
    post_comment(token, ticket_message, ticket_id)


def log_nirvana_instance_launch_in_ticket(token, ticket_id, task, workflow_id, workflow_instance_id):
    ticket_message = "New Nirvana workflow instance - https://nirvana.yandex-team.ru/flow/{}/{}/graph launched from sandbox task ({}): http://sandbox.yandex-team.ru/sandbox/tasks/view?task_id={}\n".format(workflow_id, workflow_instance_id, task.type, task.id)
    post_comment(token, ticket_message, ticket_id)
